/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.net.jpountz.lz4;

import org.graylog.shaded.kafka09.net.jpountz.lz4.LZ4Exception;
import org.graylog.shaded.kafka09.net.jpountz.lz4.LZ4SafeDecompressor;
import org.graylog.shaded.kafka09.net.jpountz.lz4.LZ4UnsafeUtils;
import org.graylog.shaded.kafka09.net.jpountz.util.UnsafeUtils;
import org.graylog.shaded.kafka09.net.jpountz.util.Utils;

final class LZ4JavaUnsafeSafeDecompressor
extends LZ4SafeDecompressor {
    public static final LZ4SafeDecompressor INSTANCE = new LZ4JavaUnsafeSafeDecompressor();

    LZ4JavaUnsafeSafeDecompressor() {
    }

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int destLen) {
        int literalCopyEnd;
        Utils.checkRange(src, srcOff, srcLen);
        Utils.checkRange(dest, destOff, destLen);
        if (destLen == 0) {
            if (srcLen != 1 || src[srcOff] != 0) {
                throw new LZ4Exception("Output buffer too small");
            }
            return 0;
        }
        int srcEnd = srcOff + srcLen;
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            int token2 = UnsafeUtils.readByte(src, sOff) & 0xFF;
            ++sOff;
            int literalLen = token2 >>> 4;
            if (literalLen == 15) {
                int len = -1;
                while (sOff < srcEnd && (len = src[sOff++]) == -1) {
                    literalLen += 255;
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) > destEnd - 8 || sOff + literalLen > srcEnd - 8) {
                if (literalCopyEnd > destEnd) {
                    throw new LZ4Exception();
                }
                if (sOff + literalLen != srcEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4UnsafeUtils.safeArraycopy(src, sOff, dest, dOff, literalLen);
                sOff += literalLen;
                break;
            }
            LZ4UnsafeUtils.wildArraycopy(src, sOff, dest, dOff, literalLen);
            dOff = literalCopyEnd;
            int matchDec = LZ4UnsafeUtils.readShortLittleEndian(src, sOff += literalLen);
            sOff += 2;
            int matchOff = dOff - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token2 & 0xF;
            if (matchLen == 15) {
                int len = -1;
                while (sOff < srcEnd && (len = src[sOff++]) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4UnsafeUtils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4UnsafeUtils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
        dOff = literalCopyEnd;
        return dOff - destOff;
    }
}

