/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.kafka.common.network;

import java.nio.channels.SelectionKey;
import java.util.Map;
import org.graylog.shaded.kafka09.org.apache.kafka.common.KafkaException;
import org.graylog.shaded.kafka09.org.apache.kafka.common.network.ChannelBuilder;
import org.graylog.shaded.kafka09.org.apache.kafka.common.network.ChannelBuilders;
import org.graylog.shaded.kafka09.org.apache.kafka.common.network.DefaultAuthenticator;
import org.graylog.shaded.kafka09.org.apache.kafka.common.network.KafkaChannel;
import org.graylog.shaded.kafka09.org.apache.kafka.common.network.PlaintextTransportLayer;
import org.graylog.shaded.kafka09.org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.graylog.shaded.kafka09.org.slf4j.Logger;
import org.graylog.shaded.kafka09.org.slf4j.LoggerFactory;

public class PlaintextChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(PlaintextChannelBuilder.class);
    private PrincipalBuilder principalBuilder;
    private Map<String, ?> configs;

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize) throws KafkaException {
        KafkaChannel channel = null;
        try {
            PlaintextTransportLayer transportLayer = new PlaintextTransportLayer(key);
            DefaultAuthenticator authenticator = new DefaultAuthenticator();
            authenticator.configure(transportLayer, this.principalBuilder, this.configs);
            channel = new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize);
        }
        catch (Exception e) {
            log.warn("Failed to create channel due to ", e);
            throw new KafkaException(e);
        }
        return channel;
    }

    @Override
    public void close() {
        this.principalBuilder.close();
    }
}

