/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.graylog.shaded.kafka09.org.apache.kafka.common.Node;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.ApiKeys;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.Errors;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.ProtoUtils;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Schema;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Struct;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.AbstractRequest;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.AbstractRequestResponse;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.GroupCoordinatorResponse;

public class GroupCoordinatorRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.GROUP_COORDINATOR.id);
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private final String groupId;

    public GroupCoordinatorRequest(String groupId) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        this.groupId = groupId;
    }

    public GroupCoordinatorRequest(Struct struct) {
        super(struct);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                return new GroupCoordinatorResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code(), Node.noNode());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.GROUP_COORDINATOR.id)));
    }

    public String groupId() {
        return this.groupId;
    }

    public static GroupCoordinatorRequest parse(ByteBuffer buffer, int versionId) {
        return new GroupCoordinatorRequest(ProtoUtils.parseRequest(ApiKeys.GROUP_COORDINATOR.id, versionId, buffer));
    }

    public static GroupCoordinatorRequest parse(ByteBuffer buffer) {
        return new GroupCoordinatorRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

