/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.kafka09.org.apache.kafka.common.TopicPartition;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.ApiKeys;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.Errors;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.ProtoUtils;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Schema;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Struct;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.AbstractRequest;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.AbstractRequestResponse;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.OffsetCommitResponse;
import org.graylog.shaded.kafka09.org.apache.kafka.common.utils.CollectionUtils;

public class OffsetCommitRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.OFFSET_COMMIT.id);
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String GENERATION_ID_KEY_NAME = "group_generation_id";
    private static final String MEMBER_ID_KEY_NAME = "member_id";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String RETENTION_TIME_KEY_NAME = "retention_time";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String COMMIT_OFFSET_KEY_NAME = "offset";
    private static final String METADATA_KEY_NAME = "metadata";
    @Deprecated
    private static final String TIMESTAMP_KEY_NAME = "timestamp";
    public static final int DEFAULT_GENERATION_ID = -1;
    public static final String DEFAULT_MEMBER_ID = "";
    public static final long DEFAULT_RETENTION_TIME = -1L;
    @Deprecated
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final String groupId;
    private final String memberId;
    private final int generationId;
    private final long retentionTime;
    private final Map<TopicPartition, PartitionData> offsetData;

    @Deprecated
    public OffsetCommitRequest(String groupId, Map<TopicPartition, PartitionData> offsetData) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.OFFSET_COMMIT.id, 0)));
        this.initCommonFields(groupId, offsetData);
        this.groupId = groupId;
        this.generationId = -1;
        this.memberId = DEFAULT_MEMBER_ID;
        this.retentionTime = -1L;
        this.offsetData = offsetData;
    }

    @Deprecated
    public OffsetCommitRequest(String groupId, int generationId, String memberId, Map<TopicPartition, PartitionData> offsetData) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.OFFSET_COMMIT.id, 1)));
        this.initCommonFields(groupId, offsetData);
        this.struct.set(GENERATION_ID_KEY_NAME, (Object)generationId);
        this.struct.set(MEMBER_ID_KEY_NAME, (Object)memberId);
        this.groupId = groupId;
        this.generationId = generationId;
        this.memberId = memberId;
        this.retentionTime = -1L;
        this.offsetData = offsetData;
    }

    public OffsetCommitRequest(String groupId, int generationId, String memberId, long retentionTime, Map<TopicPartition, PartitionData> offsetData) {
        super(new Struct(CURRENT_SCHEMA));
        this.initCommonFields(groupId, offsetData);
        this.struct.set(GENERATION_ID_KEY_NAME, (Object)generationId);
        this.struct.set(MEMBER_ID_KEY_NAME, (Object)memberId);
        this.struct.set(RETENTION_TIME_KEY_NAME, (Object)retentionTime);
        this.groupId = groupId;
        this.generationId = generationId;
        this.memberId = memberId;
        this.retentionTime = retentionTime;
        this.offsetData = offsetData;
    }

    private void initCommonFields(String groupId, Map<TopicPartition, PartitionData> offsetData) {
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(offsetData);
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(TOPICS_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData fetchPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(COMMIT_OFFSET_KEY_NAME, (Object)fetchPartitionData.offset);
                if (partitionData.hasField(TIMESTAMP_KEY_NAME)) {
                    partitionData.set(TIMESTAMP_KEY_NAME, (Object)fetchPartitionData.timestamp);
                }
                partitionData.set(METADATA_KEY_NAME, (Object)fetchPartitionData.metadata);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
    }

    public OffsetCommitRequest(Struct struct) {
        super(struct);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.generationId = struct.hasField(GENERATION_ID_KEY_NAME) ? struct.getInt(GENERATION_ID_KEY_NAME) : -1;
        this.memberId = struct.hasField(MEMBER_ID_KEY_NAME) ? struct.getString(MEMBER_ID_KEY_NAME) : DEFAULT_MEMBER_ID;
        this.retentionTime = struct.hasField(RETENTION_TIME_KEY_NAME) ? struct.getLong(RETENTION_TIME_KEY_NAME) : -1L;
        this.offsetData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicDataObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicData = (Struct)topicDataObj;
            String topic = topicData.getString(TOPIC_KEY_NAME);
            for (Object partitionDataObj : topicData.getArray(PARTITIONS_KEY_NAME)) {
                PartitionData partitionOffset;
                Struct partitionDataStruct = (Struct)partitionDataObj;
                int partition2 = partitionDataStruct.getInt(PARTITION_KEY_NAME);
                long offset = partitionDataStruct.getLong(COMMIT_OFFSET_KEY_NAME);
                String metadata = partitionDataStruct.getString(METADATA_KEY_NAME);
                if (partitionDataStruct.hasField(TIMESTAMP_KEY_NAME)) {
                    long timestamp = partitionDataStruct.getLong(TIMESTAMP_KEY_NAME);
                    partitionOffset = new PartitionData(offset, timestamp, metadata);
                } else {
                    partitionOffset = new PartitionData(offset, metadata);
                }
                this.offsetData.put(new TopicPartition(topic, partition2), partitionOffset);
            }
        }
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        HashMap<TopicPartition, Short> responseData = new HashMap<TopicPartition, Short>();
        for (Map.Entry<TopicPartition, PartitionData> entry2 : this.offsetData.entrySet()) {
            responseData.put(entry2.getKey(), Errors.forException(e).code());
        }
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new OffsetCommitResponse(responseData);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.OFFSET_COMMIT.id)));
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public long retentionTime() {
        return this.retentionTime;
    }

    public Map<TopicPartition, PartitionData> offsetData() {
        return this.offsetData;
    }

    public static OffsetCommitRequest parse(ByteBuffer buffer, int versionId) {
        Schema schema = ProtoUtils.requestSchema(ApiKeys.OFFSET_COMMIT.id, versionId);
        return new OffsetCommitRequest((Struct)schema.read(buffer));
    }

    public static OffsetCommitRequest parse(ByteBuffer buffer) {
        return new OffsetCommitRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }

    public static final class PartitionData {
        @Deprecated
        public final long timestamp;
        public final long offset;
        public final String metadata;

        @Deprecated
        public PartitionData(long offset, long timestamp, String metadata) {
            this.offset = offset;
            this.timestamp = timestamp;
            this.metadata = metadata;
        }

        public PartitionData(long offset, String metadata) {
            this(offset, -1L, metadata);
        }
    }
}

