/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.ApiKeys;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.ProtoUtils;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Schema;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Struct;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.AbstractRequestResponse;

public class SyncGroupResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.SYNC_GROUP.id);
    public static final String ERROR_CODE_KEY_NAME = "error_code";
    public static final String MEMBER_ASSIGNMENT_KEY_NAME = "member_assignment";
    private final short errorCode;
    private final ByteBuffer memberState;

    public SyncGroupResponse(short errorCode, ByteBuffer memberState) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        this.struct.set(MEMBER_ASSIGNMENT_KEY_NAME, (Object)memberState);
        this.errorCode = errorCode;
        this.memberState = memberState;
    }

    public SyncGroupResponse(Struct struct) {
        super(struct);
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
        this.memberState = struct.getBytes(MEMBER_ASSIGNMENT_KEY_NAME);
    }

    public short errorCode() {
        return this.errorCode;
    }

    public ByteBuffer memberAssignment() {
        return this.memberState;
    }

    public static SyncGroupResponse parse(ByteBuffer buffer) {
        return new SyncGroupResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

