/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Properties;
import org.graylog.shaded.kafka09.javax.swing.BorderFactory;
import org.graylog.shaded.kafka09.javax.swing.JFrame;
import org.graylog.shaded.kafka09.javax.swing.JMenu;
import org.graylog.shaded.kafka09.javax.swing.JMenuBar;
import org.graylog.shaded.kafka09.javax.swing.JMenuItem;
import org.graylog.shaded.kafka09.javax.swing.JOptionPane;
import org.graylog.shaded.kafka09.javax.swing.JScrollPane;
import org.graylog.shaded.kafka09.javax.swing.JSplitPane;
import org.graylog.shaded.kafka09.javax.swing.JTable;
import org.graylog.shaded.kafka09.javax.swing.border.Border;
import org.graylog.shaded.kafka09.javax.swing.table.TableModel;
import org.graylog.shaded.kafka09.org.apache.log4j.Logger;
import org.graylog.shaded.kafka09.org.apache.log4j.PropertyConfigurator;
import org.graylog.shaded.kafka09.org.apache.log4j.chainsaw.ControlPanel;
import org.graylog.shaded.kafka09.org.apache.log4j.chainsaw.DetailPanel;
import org.graylog.shaded.kafka09.org.apache.log4j.chainsaw.ExitAction;
import org.graylog.shaded.kafka09.org.apache.log4j.chainsaw.LoadXMLAction;
import org.graylog.shaded.kafka09.org.apache.log4j.chainsaw.LoggingReceiver;
import org.graylog.shaded.kafka09.org.apache.log4j.chainsaw.MyTableModel;

public class Main
extends JFrame {
    private static final int DEFAULT_PORT = 4445;
    public static final String PORT_PROP_NAME = "chainsaw.port";
    private static final Logger LOG = Logger.getLogger(class$org$apache$log4j$chainsaw$Main == null ? (class$org$apache$log4j$chainsaw$Main = Main.class$("org.graylog.shaded.kafka09.org.apache.log4j.chainsaw.Main")) : class$org$apache$log4j$chainsaw$Main);
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$Main;

    private Main() {
        super("CHAINSAW - Log4J Log Viewer");
        MyTableModel model = new MyTableModel();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        try {
            LoadXMLAction lxa = new LoadXMLAction(this, model);
            JMenuItem loadMenuItem = new JMenuItem("Load file...");
            menu.add(loadMenuItem);
            loadMenuItem.addActionListener((ActionListener)((Object)lxa));
        }
        catch (NoClassDefFoundError e) {
            LOG.info("Missing classes for XML parser", e);
            JOptionPane.showMessageDialog((Component)((Object)this), (Object)"XML parser not in classpath - unable to load XML events.", (String)"CHAINSAW", (int)0);
        }
        catch (Exception e) {
            LOG.info("Unable to create the action to load XML files", e);
            JOptionPane.showMessageDialog((Component)((Object)this), (Object)"Unable to create a XML parser - unable to load XML events.", (String)"CHAINSAW", (int)0);
        }
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        menu.add(exitMenuItem);
        exitMenuItem.addActionListener((ActionListener)((Object)ExitAction.INSTANCE));
        ControlPanel cp = new ControlPanel(model);
        this.getContentPane().add((Component)((Object)cp), "North");
        JTable table = new JTable((TableModel)model);
        table.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane((Component)table);
        scrollPane.setBorder((Border)BorderFactory.createTitledBorder((String)"Events: "));
        scrollPane.setPreferredSize(new Dimension(900, 300));
        DetailPanel details = new DetailPanel(table, model);
        details.setPreferredSize(new Dimension(900, 300));
        JSplitPane jsp = new JSplitPane(0, (Component)scrollPane, (Component)((Object)details));
        this.getContentPane().add((Component)jsp, "Center");
        ((Window)((Object)this)).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent aEvent) {
                ExitAction.INSTANCE.actionPerformed(null);
            }
        });
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).setVisible(true);
        this.setupReceiver(model);
    }

    private void setupReceiver(MyTableModel aModel) {
        int port = 4445;
        String strRep = System.getProperty(PORT_PROP_NAME);
        if (strRep != null) {
            try {
                port = Integer.parseInt(strRep);
            }
            catch (NumberFormatException nfe) {
                LOG.fatal("Unable to parse chainsaw.port property with value " + strRep + ".");
                JOptionPane.showMessageDialog((Component)((Object)this), (Object)("Unable to parse port number from '" + strRep + "', quitting."), (String)"CHAINSAW", (int)0);
                System.exit(1);
            }
        }
        try {
            LoggingReceiver lr = new LoggingReceiver(aModel, port);
            lr.start();
        }
        catch (IOException e) {
            LOG.fatal("Unable to connect to socket server, quiting", e);
            JOptionPane.showMessageDialog((Component)((Object)this), (Object)("Unable to create socket on port " + port + ", quitting."), (String)"CHAINSAW", (int)0);
            System.exit(1);
        }
    }

    private static void initLog4J() {
        Properties props = new Properties();
        props.setProperty("log4j.rootLogger", "DEBUG, A1");
        props.setProperty("log4j.appender.A1", "org.graylog.shaded.kafka09.org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.graylog.shaded.kafka09.org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure(props);
    }

    public static void main(String[] aArgs) {
        Main.initLog4J();
        new Main();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

