/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.log4j.jmx;

import java.util.Iterator;
import org.graylog.shaded.kafka09.javax.management.Attribute;
import org.graylog.shaded.kafka09.javax.management.AttributeList;
import org.graylog.shaded.kafka09.javax.management.AttributeNotFoundException;
import org.graylog.shaded.kafka09.javax.management.DynamicMBean;
import org.graylog.shaded.kafka09.javax.management.InvalidAttributeValueException;
import org.graylog.shaded.kafka09.javax.management.MBeanException;
import org.graylog.shaded.kafka09.javax.management.MBeanInfo;
import org.graylog.shaded.kafka09.javax.management.MBeanRegistration;
import org.graylog.shaded.kafka09.javax.management.MBeanServer;
import org.graylog.shaded.kafka09.javax.management.ObjectName;
import org.graylog.shaded.kafka09.javax.management.ReflectionException;
import org.graylog.shaded.kafka09.javax.management.RuntimeOperationsException;
import org.graylog.shaded.kafka09.org.apache.log4j.Logger;

public abstract class AbstractDynamicMBean
implements DynamicMBean,
MBeanRegistration {
    String dClassName;
    MBeanServer server;

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException((RuntimeException)new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value2 = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value2));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException((RuntimeException)new IllegalArgumentException("AttributeList attributes cannot be null"), "Cannot invoke a setter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value2 = this.getAttribute(name);
                resultList.add(new Attribute(name, value2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    protected abstract Logger getLogger();

    public void postDeregister() {
        this.getLogger().debug("postDeregister is called.");
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() {
        this.getLogger().debug("preDeregister called.");
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        this.getLogger().debug("preRegister called. Server=" + server + ", name=" + name);
        this.server = server;
        return name;
    }

    public abstract /* synthetic */ MBeanInfo getMBeanInfo();

    public abstract /* synthetic */ Object invoke(String var1, Object[] var2, String[] var3) throws MBeanException, ReflectionException;

    public abstract /* synthetic */ void setAttribute(Attribute var1) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException;

    public abstract /* synthetic */ Object getAttribute(String var1) throws AttributeNotFoundException, MBeanException, ReflectionException;
}

