/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.log4j.jmx;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.graylog.shaded.kafka09.javax.management.Attribute;
import org.graylog.shaded.kafka09.javax.management.AttributeNotFoundException;
import org.graylog.shaded.kafka09.javax.management.InvalidAttributeValueException;
import org.graylog.shaded.kafka09.javax.management.MBeanAttributeInfo;
import org.graylog.shaded.kafka09.javax.management.MBeanConstructorInfo;
import org.graylog.shaded.kafka09.javax.management.MBeanException;
import org.graylog.shaded.kafka09.javax.management.MBeanInfo;
import org.graylog.shaded.kafka09.javax.management.MBeanNotificationInfo;
import org.graylog.shaded.kafka09.javax.management.MBeanOperationInfo;
import org.graylog.shaded.kafka09.javax.management.MBeanParameterInfo;
import org.graylog.shaded.kafka09.javax.management.MBeanServer;
import org.graylog.shaded.kafka09.javax.management.ObjectName;
import org.graylog.shaded.kafka09.javax.management.ReflectionException;
import org.graylog.shaded.kafka09.javax.management.RuntimeOperationsException;
import org.graylog.shaded.kafka09.org.apache.log4j.Appender;
import org.graylog.shaded.kafka09.org.apache.log4j.Layout;
import org.graylog.shaded.kafka09.org.apache.log4j.Level;
import org.graylog.shaded.kafka09.org.apache.log4j.Logger;
import org.graylog.shaded.kafka09.org.apache.log4j.helpers.OptionConverter;
import org.graylog.shaded.kafka09.org.apache.log4j.jmx.AbstractDynamicMBean;
import org.graylog.shaded.kafka09.org.apache.log4j.jmx.LayoutDynamicMBean;
import org.graylog.shaded.kafka09.org.apache.log4j.jmx.MethodUnion;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.OptionHandler;

public class AppenderDynamicMBean
extends AbstractDynamicMBean {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private Vector dAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private Hashtable dynamicProps = new Hashtable(5);
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[2];
    private String dDescription = "This MBean acts as a management facade for log4j appenders.";
    private static Logger cat = Logger.getLogger(class$org$apache$log4j$jmx$AppenderDynamicMBean == null ? (class$org$apache$log4j$jmx$AppenderDynamicMBean = AppenderDynamicMBean.class$("org.graylog.shaded.kafka09.org.apache.log4j.jmx.AppenderDynamicMBean")) : class$org$apache$log4j$jmx$AppenderDynamicMBean);
    private Appender appender;
    static /* synthetic */ Class class$org$apache$log4j$jmx$AppenderDynamicMBean;
    static /* synthetic */ Class class$org$apache$log4j$Priority;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Layout;

    public AppenderDynamicMBean(Appender appender) throws IntrospectionException {
        this.appender = appender;
        this.buildDynamicMBeanInfo();
    }

    private void buildDynamicMBeanInfo() throws IntrospectionException {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("AppenderDynamicMBean(): Constructs a AppenderDynamicMBean instance", constructors[0]);
        BeanInfo bi = Introspector.getBeanInfo(this.appender.getClass());
        PropertyDescriptor[] pd = bi.getPropertyDescriptors();
        int size2 = pd.length;
        for (int i = 0; i < size2; ++i) {
            Class<?> returnClass;
            String name = pd[i].getName();
            Method readMethod = pd[i].getReadMethod();
            Method writeMethod = pd[i].getWriteMethod();
            if (readMethod == null || !this.isSupportedType(returnClass = readMethod.getReturnType())) continue;
            String returnClassName = returnClass.isAssignableFrom(class$org$apache$log4j$Priority == null ? AppenderDynamicMBean.class$("org.graylog.shaded.kafka09.org.apache.log4j.Priority") : class$org$apache$log4j$Priority) ? "java.lang.String" : returnClass.getName();
            this.dAttributes.add(new MBeanAttributeInfo(name, returnClassName, "Dynamic", true, writeMethod != null, false));
            this.dynamicProps.put(name, new MethodUnion(readMethod, writeMethod));
        }
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        this.dOperations[0] = new MBeanOperationInfo("activateOptions", "activateOptions(): add an appender", params, "void", 1);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("layout class", "java.lang.String", "layout class")};
        this.dOperations[1] = new MBeanOperationInfo("setLayout", "setLayout(): add a layout", params, "void", 1);
    }

    private boolean isSupportedType(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AppenderDynamicMBean.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        return clazz.isAssignableFrom(class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = AppenderDynamicMBean.class$("org.graylog.shaded.kafka09.org.apache.log4j.Priority")) : class$org$apache$log4j$Priority);
    }

    public MBeanInfo getMBeanInfo() {
        cat.debug("getMBeanInfo called.");
        MBeanAttributeInfo[] attribs = new MBeanAttributeInfo[this.dAttributes.size()];
        this.dAttributes.toArray(attribs);
        return new MBeanInfo(this.dClassName, this.dDescription, attribs, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName.equals("activateOptions") && this.appender instanceof OptionHandler) {
            OptionHandler oh = (OptionHandler)((Object)this.appender);
            oh.activateOptions();
            return "Options activated.";
        }
        if (operationName.equals("setLayout")) {
            Layout layout = (Layout)OptionConverter.instantiateByClassName((String)params[0], class$org$apache$log4j$Layout == null ? (class$org$apache$log4j$Layout = AppenderDynamicMBean.class$("org.graylog.shaded.kafka09.org.apache.log4j.Layout")) : class$org$apache$log4j$Layout, null);
            this.appender.setLayout(layout);
            this.registerLayoutMBean(layout);
        }
        return null;
    }

    void registerLayoutMBean(Layout layout) {
        if (layout == null) {
            return;
        }
        String name = this.appender.getName() + ",layout=" + layout.getClass().getName();
        cat.debug("Adding LayoutMBean:" + name);
        ObjectName objectName = null;
        try {
            LayoutDynamicMBean appenderMBean = new LayoutDynamicMBean(layout);
            objectName = new ObjectName("log4j:appender=" + name);
            if (!this.server.isRegistered(objectName)) {
                this.server.registerMBean((Object)appenderMBean, objectName);
                this.dAttributes.add(new MBeanAttributeInfo("appender=" + name, "org.graylog.shaded.kafka09.javax.management.ObjectName", "The " + name + " layout.", true, true, false));
            }
        }
        catch (Exception e) {
            cat.error("Could not add DynamicLayoutMBean for [" + name + "].", e);
        }
    }

    protected Logger getLogger() {
        return cat;
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MethodUnion mu;
        if (attributeName == null) {
            throw new RuntimeOperationsException((RuntimeException)new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        cat.debug("getAttribute called with [" + attributeName + "].");
        if (attributeName.startsWith("appender=" + this.appender.getName() + ",layout")) {
            try {
                return new ObjectName("log4j:" + attributeName);
            }
            catch (Exception e) {
                cat.error("attributeName", e);
            }
        }
        if ((mu = (MethodUnion)this.dynamicProps.get(attributeName)) != null && mu.readMethod != null) {
            try {
                return mu.readMethod.invoke((Object)this.appender, null);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new AttributeNotFoundException("Cannot find " + attributeName + " attribute in " + this.dClassName);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException((RuntimeException)new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String name = attribute.getName();
        Object value2 = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException((RuntimeException)new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        MethodUnion mu = (MethodUnion)this.dynamicProps.get(name);
        if (mu != null && mu.writeMethod != null) {
            Object[] o = new Object[1];
            Class<?>[] params = mu.writeMethod.getParameterTypes();
            if (params[0] == (class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = AppenderDynamicMBean.class$("org.graylog.shaded.kafka09.org.apache.log4j.Priority")) : class$org$apache$log4j$Priority)) {
                value2 = OptionConverter.toLevel((String)value2, (Level)this.getAttribute(name));
            }
            o[0] = value2;
            try {
                mu.writeMethod.invoke((Object)this.appender, o);
            }
            catch (Exception e) {
                cat.error("FIXME", e);
            }
        } else if (!name.endsWith(".layout")) {
            throw new AttributeNotFoundException("Attribute " + name + " not found in " + this.getClass().getName());
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        cat.debug("preRegister called. Server=" + server + ", name=" + name);
        this.server = server;
        this.registerLayoutMBean(this.appender.getLayout());
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

