/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.log4j.net;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.graylog.shaded.kafka09.javax.mail.Authenticator;
import org.graylog.shaded.kafka09.javax.mail.Message;
import org.graylog.shaded.kafka09.javax.mail.MessagingException;
import org.graylog.shaded.kafka09.javax.mail.PasswordAuthentication;
import org.graylog.shaded.kafka09.javax.mail.Session;
import org.graylog.shaded.kafka09.javax.mail.Transport;
import org.graylog.shaded.kafka09.javax.mail.internet.AddressException;
import org.graylog.shaded.kafka09.javax.mail.internet.InternetAddress;
import org.graylog.shaded.kafka09.javax.mail.internet.MimeBodyPart;
import org.graylog.shaded.kafka09.javax.mail.internet.MimeMessage;
import org.graylog.shaded.kafka09.javax.mail.internet.MimeMultipart;
import org.graylog.shaded.kafka09.org.apache.log4j.AppenderSkeleton;
import org.graylog.shaded.kafka09.org.apache.log4j.Layout;
import org.graylog.shaded.kafka09.org.apache.log4j.helpers.CyclicBuffer;
import org.graylog.shaded.kafka09.org.apache.log4j.helpers.LogLog;
import org.graylog.shaded.kafka09.org.apache.log4j.helpers.OptionConverter;
import org.graylog.shaded.kafka09.org.apache.log4j.net.DefaultEvaluator;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.LoggingEvent;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.OptionHandler;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.TriggeringEventEvaluator;
import org.graylog.shaded.kafka09.org.apache.log4j.xml.DOMConfigurator;
import org.graylog.shaded.kafka09.org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public class SMTPAppender
extends AppenderSkeleton
implements UnrecognizedElementHandler {
    private String to;
    private String cc;
    private String bcc;
    private String from;
    private String subject;
    private String smtpHost;
    private String smtpUsername;
    private String smtpPassword;
    private boolean smtpDebug = false;
    private int bufferSize = 512;
    private boolean locationInfo = false;
    protected CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
    protected Message msg;
    protected TriggeringEventEvaluator evaluator;
    static /* synthetic */ Class class$org$apache$log4j$spi$TriggeringEventEvaluator;

    public SMTPAppender() {
        this(new DefaultEvaluator());
    }

    public SMTPAppender(TriggeringEventEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void activateOptions() {
        Session session = this.createSession();
        this.msg = new MimeMessage(session);
        try {
            this.addressMessage(this.msg);
            if (this.subject != null) {
                this.msg.setSubject(this.subject);
            }
        }
        catch (MessagingException e) {
            LogLog.error("Could not activate SMTPAppender options.", e);
        }
        if (this.evaluator instanceof OptionHandler) {
            ((OptionHandler)((Object)this.evaluator)).activateOptions();
        }
    }

    protected void addressMessage(Message msg) throws MessagingException {
        if (this.from != null) {
            msg.setFrom(this.getAddress(this.from));
        } else {
            msg.setFrom();
        }
        if (this.to != null && this.to.length() > 0) {
            msg.setRecipients(Message.RecipientType.TO, this.parseAddress(this.to));
        }
        if (this.cc != null && this.cc.length() > 0) {
            msg.setRecipients(Message.RecipientType.CC, this.parseAddress(this.cc));
        }
        if (this.bcc != null && this.bcc.length() > 0) {
            msg.setRecipients(Message.RecipientType.BCC, this.parseAddress(this.bcc));
        }
    }

    protected Session createSession() {
        Properties props = null;
        try {
            props = new Properties(System.getProperties());
        }
        catch (SecurityException ex) {
            props = new Properties();
        }
        if (this.smtpHost != null) {
            ((Hashtable)props).put("mail.smtp.host", this.smtpHost);
        }
        Authenticator auth = null;
        if (this.smtpPassword != null && this.smtpUsername != null) {
            ((Hashtable)props).put("mail.smtp.auth", "true");
            auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SMTPAppender.this.smtpUsername, SMTPAppender.this.smtpPassword);
                }
            };
        }
        Session session = Session.getInstance(props, auth);
        if (this.smtpDebug) {
            session.setDebug(this.smtpDebug);
        }
        return session;
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        event.getThreadName();
        event.getNDC();
        event.getMDCCopy();
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        this.cb.add(event);
        if (this.evaluator.isTriggeringEvent(event)) {
            this.sendBuffer();
        }
    }

    protected boolean checkEntryConditions() {
        if (this.msg == null) {
            this.errorHandler.error("Message object not configured.");
            return false;
        }
        if (this.evaluator == null) {
            this.errorHandler.error("No TriggeringEventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        this.closed = true;
    }

    InternetAddress getAddress(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            this.errorHandler.error("Could not parse address [" + addressStr + "].", e, 6);
            return null;
        }
    }

    InternetAddress[] parseAddress(String addressStr) {
        try {
            return InternetAddress.parse(addressStr, true);
        }
        catch (AddressException e) {
            this.errorHandler.error("Could not parse address [" + addressStr + "].", e, 6);
            return null;
        }
    }

    public String getTo() {
        return this.to;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void sendBuffer() {
        try {
            MimeBodyPart part = new MimeBodyPart();
            StringBuffer sbuf = new StringBuffer();
            String t = this.layout.getHeader();
            if (t != null) {
                sbuf.append(t);
            }
            int len = this.cb.length();
            for (int i = 0; i < len; ++i) {
                String[] s2;
                LoggingEvent event = this.cb.get();
                sbuf.append(this.layout.format(event));
                if (!this.layout.ignoresThrowable() || (s2 = event.getThrowableStrRep()) == null) continue;
                for (int j = 0; j < s2.length; ++j) {
                    sbuf.append(s2[j]);
                    sbuf.append(Layout.LINE_SEP);
                }
            }
            t = this.layout.getFooter();
            if (t != null) {
                sbuf.append(t);
            }
            part.setContent(sbuf.toString(), this.layout.getContentType());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart(part);
            this.msg.setContent(mp);
            this.msg.setSentDate(new Date());
            Transport.send(this.msg);
        }
        catch (Exception e) {
            LogLog.error("Error occured while sending e-mail notification.", e);
        }
    }

    public String getEvaluatorClass() {
        return this.evaluator == null ? null : this.evaluator.getClass().getName();
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setFrom(String from2) {
        this.from = from2;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.cb.resize(bufferSize);
    }

    public void setSMTPHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setTo(String to2) {
        this.to = to2;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setEvaluatorClass(String value2) {
        this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName(value2, class$org$apache$log4j$spi$TriggeringEventEvaluator == null ? (class$org$apache$log4j$spi$TriggeringEventEvaluator = SMTPAppender.class$("org.graylog.shaded.kafka09.org.apache.log4j.spi.TriggeringEventEvaluator")) : class$org$apache$log4j$spi$TriggeringEventEvaluator, this.evaluator);
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setCc(String addresses) {
        this.cc = addresses;
    }

    public String getCc() {
        return this.cc;
    }

    public void setBcc(String addresses) {
        this.bcc = addresses;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setSMTPPassword(String password) {
        this.smtpPassword = password;
    }

    public void setSMTPUsername(String username) {
        this.smtpUsername = username;
    }

    public void setSMTPDebug(boolean debug) {
        this.smtpDebug = debug;
    }

    public String getSMTPPassword() {
        return this.smtpPassword;
    }

    public String getSMTPUsername() {
        return this.smtpUsername;
    }

    public boolean getSMTPDebug() {
        return this.smtpDebug;
    }

    public final void setEvaluator(TriggeringEventEvaluator trigger) {
        if (trigger == null) {
            throw new NullPointerException("trigger");
        }
        this.evaluator = trigger;
    }

    public final TriggeringEventEvaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        if ("triggeringPolicy".equals(element.getNodeName())) {
            Object triggerPolicy = DOMConfigurator.parseElement(element, props, class$org$apache$log4j$spi$TriggeringEventEvaluator == null ? (class$org$apache$log4j$spi$TriggeringEventEvaluator = SMTPAppender.class$("org.graylog.shaded.kafka09.org.apache.log4j.spi.TriggeringEventEvaluator")) : class$org$apache$log4j$spi$TriggeringEventEvaluator);
            if (triggerPolicy instanceof TriggeringEventEvaluator) {
                this.setEvaluator((TriggeringEventEvaluator)triggerPolicy);
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

