/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.graylog.shaded.kafka09.org.apache.jute.InputArchive;
import org.graylog.shaded.kafka09.org.apache.jute.OutputArchive;
import org.graylog.shaded.kafka09.org.apache.jute.Record;
import org.graylog.shaded.kafka09.org.apache.zookeeper.OpResult;
import org.graylog.shaded.kafka09.org.apache.zookeeper.proto.CreateResponse;
import org.graylog.shaded.kafka09.org.apache.zookeeper.proto.ErrorResponse;
import org.graylog.shaded.kafka09.org.apache.zookeeper.proto.MultiHeader;
import org.graylog.shaded.kafka09.org.apache.zookeeper.proto.SetDataResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiResponse
implements Record,
Iterable<OpResult> {
    private List<OpResult> results = new ArrayList<OpResult>();

    public void add(OpResult x) {
        this.results.add(x);
    }

    @Override
    public Iterator<OpResult> iterator() {
        return this.results.iterator();
    }

    public int size() {
        return this.results.size();
    }

    @Override
    public void serialize(OutputArchive archive, String tag) throws IOException {
        archive.startRecord(this, tag);
        boolean index2 = false;
        block6: for (OpResult result2 : this.results) {
            int err2 = result2.getType() == -1 ? ((OpResult.ErrorResult)result2).getErr() : 0;
            new MultiHeader(result2.getType(), false, err2).serialize(archive, tag);
            switch (result2.getType()) {
                case 1: {
                    new CreateResponse(((OpResult.CreateResult)result2).getPath()).serialize(archive, tag);
                    continue block6;
                }
                case 2: 
                case 13: {
                    continue block6;
                }
                case 5: {
                    new SetDataResponse(((OpResult.SetDataResult)result2).getStat()).serialize(archive, tag);
                    continue block6;
                }
                case -1: {
                    new ErrorResponse(((OpResult.ErrorResult)result2).getErr()).serialize(archive, tag);
                    continue block6;
                }
            }
            throw new IOException("Invalid type " + result2.getType() + " in MultiResponse");
        }
        new MultiHeader(-1, true, -1).serialize(archive, tag);
        archive.endRecord(this, tag);
    }

    @Override
    public void deserialize(InputArchive archive, String tag) throws IOException {
        this.results = new ArrayList<OpResult>();
        archive.startRecord(tag);
        MultiHeader h = new MultiHeader();
        h.deserialize(archive, tag);
        while (!h.getDone()) {
            switch (h.getType()) {
                case 1: {
                    CreateResponse cr = new CreateResponse();
                    cr.deserialize(archive, tag);
                    this.results.add(new OpResult.CreateResult(cr.getPath()));
                    break;
                }
                case 2: {
                    this.results.add(new OpResult.DeleteResult());
                    break;
                }
                case 5: {
                    SetDataResponse sdr = new SetDataResponse();
                    sdr.deserialize(archive, tag);
                    this.results.add(new OpResult.SetDataResult(sdr.getStat()));
                    break;
                }
                case 13: {
                    this.results.add(new OpResult.CheckResult());
                    break;
                }
                case -1: {
                    ErrorResponse er = new ErrorResponse();
                    er.deserialize(archive, tag);
                    this.results.add(new OpResult.ErrorResult(er.getErr()));
                    break;
                }
                default: {
                    throw new IOException("Invalid type " + h.getType() + " in MultiResponse");
                }
            }
            h.deserialize(archive, tag);
        }
        archive.endRecord(tag);
    }

    public List<OpResult> getResultList() {
        return this.results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiResponse)) {
            return false;
        }
        MultiResponse other = (MultiResponse)o;
        if (this.results != null) {
            Iterator<OpResult> i = other.results.iterator();
            for (OpResult result2 : this.results) {
                if (i.hasNext()) {
                    if (result2.equals(i.next())) continue;
                    return false;
                }
                return false;
            }
            return !i.hasNext();
        }
        return other.results == null;
    }

    public int hashCode() {
        int hash = this.results.size();
        for (OpResult result2 : this.results) {
            hash = hash * 35 + result2.hashCode();
        }
        return hash;
    }
}

