/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.jboss.netty.buffer;

import java.nio.ByteOrder;
import org.graylog.shaded.kafka09.org.jboss.netty.buffer.ChannelBuffer;
import org.graylog.shaded.kafka09.org.jboss.netty.buffer.ChannelBufferFactory;
import org.graylog.shaded.kafka09.org.jboss.netty.buffer.HeapChannelBuffer;
import org.graylog.shaded.kafka09.org.jboss.netty.buffer.HeapChannelBufferFactory;

public class BigEndianHeapChannelBuffer
extends HeapChannelBuffer {
    public BigEndianHeapChannelBuffer(int length) {
        super(length);
    }

    public BigEndianHeapChannelBuffer(byte[] array) {
        super(array);
    }

    private BigEndianHeapChannelBuffer(byte[] array, int readerIndex, int writerIndex) {
        super(array, readerIndex, writerIndex);
    }

    public ChannelBufferFactory factory() {
        return HeapChannelBufferFactory.getInstance(ByteOrder.BIG_ENDIAN);
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public short getShort(int index2) {
        return (short)(this.array[index2] << 8 | this.array[index2 + 1] & 0xFF);
    }

    public int getUnsignedMedium(int index2) {
        return (this.array[index2] & 0xFF) << 16 | (this.array[index2 + 1] & 0xFF) << 8 | this.array[index2 + 2] & 0xFF;
    }

    public int getInt(int index2) {
        return (this.array[index2] & 0xFF) << 24 | (this.array[index2 + 1] & 0xFF) << 16 | (this.array[index2 + 2] & 0xFF) << 8 | this.array[index2 + 3] & 0xFF;
    }

    public long getLong(int index2) {
        return ((long)this.array[index2] & 0xFFL) << 56 | ((long)this.array[index2 + 1] & 0xFFL) << 48 | ((long)this.array[index2 + 2] & 0xFFL) << 40 | ((long)this.array[index2 + 3] & 0xFFL) << 32 | ((long)this.array[index2 + 4] & 0xFFL) << 24 | ((long)this.array[index2 + 5] & 0xFFL) << 16 | ((long)this.array[index2 + 6] & 0xFFL) << 8 | (long)this.array[index2 + 7] & 0xFFL;
    }

    public void setShort(int index2, int value2) {
        this.array[index2] = (byte)(value2 >>> 8);
        this.array[index2 + 1] = (byte)value2;
    }

    public void setMedium(int index2, int value2) {
        this.array[index2] = (byte)(value2 >>> 16);
        this.array[index2 + 1] = (byte)(value2 >>> 8);
        this.array[index2 + 2] = (byte)value2;
    }

    public void setInt(int index2, int value2) {
        this.array[index2] = (byte)(value2 >>> 24);
        this.array[index2 + 1] = (byte)(value2 >>> 16);
        this.array[index2 + 2] = (byte)(value2 >>> 8);
        this.array[index2 + 3] = (byte)value2;
    }

    public void setLong(int index2, long value2) {
        this.array[index2] = (byte)(value2 >>> 56);
        this.array[index2 + 1] = (byte)(value2 >>> 48);
        this.array[index2 + 2] = (byte)(value2 >>> 40);
        this.array[index2 + 3] = (byte)(value2 >>> 32);
        this.array[index2 + 4] = (byte)(value2 >>> 24);
        this.array[index2 + 5] = (byte)(value2 >>> 16);
        this.array[index2 + 6] = (byte)(value2 >>> 8);
        this.array[index2 + 7] = (byte)value2;
    }

    public ChannelBuffer duplicate() {
        return new BigEndianHeapChannelBuffer(this.array, this.readerIndex(), this.writerIndex());
    }

    public ChannelBuffer copy(int index2, int length) {
        if (index2 < 0 || length < 0 || index2 + length > this.array.length) {
            throw new IndexOutOfBoundsException("Too many bytes to copy - Need " + (index2 + length) + ", maximum is " + this.array.length);
        }
        byte[] copiedArray = new byte[length];
        System.arraycopy(this.array, index2, copiedArray, 0, length);
        return new BigEndianHeapChannelBuffer(copiedArray);
    }
}

