/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.nio;

import java.net.SocketAddress;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.Channel;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelEvent;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelFuture;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelPipeline;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelState;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelStateEvent;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.MessageEvent;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.nio.NioServerBoss;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.nio.NioSocketChannel;

class NioServerSocketPipelineSink
extends AbstractNioChannelSink {
    NioServerSocketPipelineSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof NioServerSocketChannel) {
            NioServerSocketPipelineSink.handleServerSocket(e);
        } else if (channel instanceof NioSocketChannel) {
            NioServerSocketPipelineSink.handleAcceptedSocket(e);
        }
    }

    private static void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        NioServerSocketChannel channel = (NioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value2 = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value2)) break;
                ((NioServerBoss)channel.boss).close(channel, future);
                break;
            }
            case BOUND: {
                if (value2 != null) {
                    ((NioServerBoss)channel.boss).bind(channel, future, (SocketAddress)value2);
                    break;
                }
                ((NioServerBoss)channel.boss).close(channel, future);
                break;
            }
        }
    }

    private static void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value2 = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value2)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value2 != null) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value2);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }
}

