/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.http.websocketx;

import org.graylog.shaded.kafka09.org.jboss.netty.buffer.ChannelBuffer;
import org.graylog.shaded.kafka09.org.jboss.netty.buffer.ChannelBuffers;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.graylog.shaded.kafka09.org.jboss.netty.util.CharsetUtil;

public class TextWebSocketFrame
extends WebSocketFrame {
    public TextWebSocketFrame() {
        this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
    }

    public TextWebSocketFrame(String text2) {
        if (text2 == null || text2.length() == 0) {
            this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
        } else {
            this.setBinaryData(ChannelBuffers.copiedBuffer((CharSequence)text2, CharsetUtil.UTF_8));
        }
    }

    public TextWebSocketFrame(ChannelBuffer binaryData) {
        this.setBinaryData(binaryData);
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, String text2) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        if (text2 == null || text2.length() == 0) {
            this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
        } else {
            this.setBinaryData(ChannelBuffers.copiedBuffer((CharSequence)text2, CharsetUtil.UTF_8));
        }
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, ChannelBuffer binaryData) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        this.setBinaryData(binaryData);
    }

    public String getText() {
        if (this.getBinaryData() == null) {
            return null;
        }
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    public void setText(String text2) {
        if (text2 == null) {
            throw new NullPointerException("text");
        }
        this.setBinaryData(ChannelBuffers.copiedBuffer((CharSequence)text2, CharsetUtil.UTF_8));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(text: " + this.getText() + ')';
    }
}

