/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.replay;

import java.net.SocketAddress;
import org.graylog.shaded.kafka09.org.jboss.netty.buffer.ChannelBuffer;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.Channel;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelHandlerContext;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelStateEvent;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.MessageEvent;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.replay.ReplayError;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.replay.ReplayingDecoderBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplayingDecoder<T extends Enum<T>>
extends FrameDecoder {
    private final ReplayingDecoderBuffer replayable = new ReplayingDecoderBuffer(this);
    private T state;
    private int checkpoint;
    private boolean needsCleanup;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(boolean unfold) {
        this(null, unfold);
    }

    protected ReplayingDecoder(T initialState) {
        this(initialState, false);
    }

    protected ReplayingDecoder(T initialState, boolean unfold) {
        super(unfold);
        this.state = initialState;
    }

    @Override
    protected ChannelBuffer internalBuffer() {
        return super.internalBuffer();
    }

    protected void checkpoint() {
        ChannelBuffer cumulation = this.cumulation;
        this.checkpoint = cumulation != null ? cumulation.readerIndex() : -1;
    }

    protected void checkpoint(T state) {
        this.checkpoint();
        this.setState(state);
    }

    protected T getState() {
        return this.state;
    }

    protected T setState(T newState) {
        T oldState = this.state;
        this.state = newState;
        return oldState;
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, ChannelBuffer var3, T var4) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, T state) throws Exception {
        return this.decode(ctx, channel, buffer, state);
    }

    @Override
    protected final Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decode(ctx, channel, buffer, this.state);
    }

    @Override
    protected final Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decodeLast(ctx, channel, buffer, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream(e);
            return;
        }
        ChannelBuffer input2 = (ChannelBuffer)m;
        if (!input2.readable()) {
            return;
        }
        this.needsCleanup = true;
        if (this.cumulation == null) {
            this.cumulation = input2;
            int oldReaderIndex = input2.readerIndex();
            int inputSize = input2.readableBytes();
            try {
                this.callDecode(ctx, e.getChannel(), input2, this.replayable, e.getRemoteAddress());
                Object var8_7 = null;
                int readableBytes = input2.readableBytes();
                if (readableBytes > 0) {
                    boolean copy;
                    int inputCapacity = input2.capacity();
                    boolean bl = copy = readableBytes != inputCapacity && inputCapacity > this.getMaxCumulationBufferCapacity();
                    if (this.checkpoint > 0) {
                        int bytesToPreserve = inputSize - (this.checkpoint - oldReaderIndex);
                        if (copy) {
                            ChannelBuffer cumulation;
                            this.cumulation = cumulation = this.newCumulationBuffer(ctx, bytesToPreserve);
                            cumulation.writeBytes(input2, this.checkpoint, bytesToPreserve);
                            return;
                        }
                        this.cumulation = input2.slice(this.checkpoint, bytesToPreserve);
                        return;
                    }
                    if (this.checkpoint == 0) {
                        ChannelBuffer cumulation;
                        if (copy) {
                            ChannelBuffer cumulation2;
                            this.cumulation = cumulation2 = this.newCumulationBuffer(ctx, inputSize);
                            cumulation2.writeBytes(input2, oldReaderIndex, inputSize);
                            cumulation2.readerIndex(input2.readerIndex());
                            return;
                        }
                        this.cumulation = cumulation = input2.slice(oldReaderIndex, inputSize);
                        cumulation.readerIndex(input2.readerIndex());
                        return;
                    }
                    if (copy) {
                        ChannelBuffer cumulation;
                        this.cumulation = cumulation = this.newCumulationBuffer(ctx, input2.readableBytes());
                        cumulation.writeBytes(input2);
                        return;
                    }
                    this.cumulation = input2;
                    return;
                }
                this.cumulation = null;
                return;
            }
            catch (Throwable throwable) {
                boolean copy;
                Object var8_8 = null;
                int readableBytes = input2.readableBytes();
                if (readableBytes <= 0) {
                    this.cumulation = null;
                    throw throwable;
                }
                int inputCapacity = input2.capacity();
                boolean bl = copy = readableBytes != inputCapacity && inputCapacity > this.getMaxCumulationBufferCapacity();
                if (this.checkpoint > 0) {
                    int bytesToPreserve = inputSize - (this.checkpoint - oldReaderIndex);
                    if (copy) {
                        ChannelBuffer cumulation;
                        this.cumulation = cumulation = this.newCumulationBuffer(ctx, bytesToPreserve);
                        cumulation.writeBytes(input2, this.checkpoint, bytesToPreserve);
                        throw throwable;
                    }
                    this.cumulation = input2.slice(this.checkpoint, bytesToPreserve);
                    throw throwable;
                }
                if (this.checkpoint == 0) {
                    ChannelBuffer cumulation;
                    if (copy) {
                        ChannelBuffer cumulation2;
                        this.cumulation = cumulation2 = this.newCumulationBuffer(ctx, inputSize);
                        cumulation2.writeBytes(input2, oldReaderIndex, inputSize);
                        cumulation2.readerIndex(input2.readerIndex());
                        throw throwable;
                    }
                    this.cumulation = cumulation = input2.slice(oldReaderIndex, inputSize);
                    cumulation.readerIndex(input2.readerIndex());
                    throw throwable;
                }
                if (copy) {
                    ChannelBuffer cumulation;
                    this.cumulation = cumulation = this.newCumulationBuffer(ctx, input2.readableBytes());
                    cumulation.writeBytes(input2);
                    throw throwable;
                }
                this.cumulation = input2;
                throw throwable;
            }
        }
        input2 = this.appendToCumulation(input2);
        try {
            this.callDecode(ctx, e.getChannel(), input2, this.replayable, e.getRemoteAddress());
            Object var15_26 = null;
            this.updateCumulation(ctx, input2);
            return;
        }
        catch (Throwable throwable) {
            Object var15_27 = null;
            this.updateCumulation(ctx, input2);
            throw throwable;
        }
    }

    private void callDecode(ChannelHandlerContext context, Channel channel, ChannelBuffer input2, ChannelBuffer replayableInput, SocketAddress remoteAddress) throws Exception {
        while (input2.readable()) {
            T oldState;
            Object result2;
            int oldReaderIndex;
            block5: {
                oldReaderIndex = this.checkpoint = input2.readerIndex();
                result2 = null;
                oldState = this.state;
                try {
                    result2 = this.decode(context, channel, replayableInput, this.state);
                    if (result2 == null) {
                        if (oldReaderIndex != input2.readerIndex() || oldState != this.state) continue;
                        throw new IllegalStateException("null cannot be returned if no data is consumed and state didn't change.");
                    }
                }
                catch (ReplayError replay) {
                    int checkpoint = this.checkpoint;
                    if (checkpoint < 0) break block5;
                    input2.readerIndex(checkpoint);
                }
            }
            if (result2 == null) break;
            if (oldReaderIndex == input2.readerIndex() && oldState == this.state) {
                throw new IllegalStateException("decode() method must consume at least one byte if it returned a decoded message (caused by: " + this.getClass() + ')');
            }
            this.unfoldAndFireMessageReceived(context, remoteAddress, result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            try {
                ChannelBuffer cumulation = this.cumulation;
                if (!this.needsCleanup) {
                    Object var6_5 = null;
                    ctx.sendUpstream(e);
                    return;
                }
                this.needsCleanup = false;
                this.replayable.terminate();
                if (cumulation != null && cumulation.readable()) {
                    this.callDecode(ctx, e.getChannel(), cumulation, this.replayable, null);
                }
                Object partiallyDecoded = this.decodeLast(ctx, e.getChannel(), this.replayable, this.state);
                this.cumulation = null;
                if (partiallyDecoded != null) {
                    this.unfoldAndFireMessageReceived(ctx, null, partiallyDecoded);
                }
            }
            catch (ReplayError replayError) {
                Object var6_7 = null;
                ctx.sendUpstream(e);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ctx.sendUpstream(e);
            throw throwable;
        }
        Object var6_6 = null;
        ctx.sendUpstream(e);
    }
}

