/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.spdy;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelHandlerContext;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.MessageEvent;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.SimpleChannelHandler;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.http.HttpMessage;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.http.HttpResponse;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.spdy.SpdyHttpHeaders;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.spdy.SpdyRstStreamFrame;

public class SpdyHttpResponseStreamIdHandler
extends SimpleChannelHandler {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new ConcurrentLinkedQueue<Integer>();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof HttpMessage) {
            boolean contains2 = ((HttpMessage)e.getMessage()).containsHeader("X-SPDY-Stream-ID");
            if (!contains2) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(SpdyHttpHeaders.getStreamId((HttpMessage)e.getMessage()));
            }
        } else if (e.getMessage() instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)e.getMessage()).getStreamId());
        }
        super.messageReceived(ctx, e);
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)e.getMessage();
            Integer id = this.ids.poll();
            if (id != null && id.intValue() != NO_ID.intValue() && !response.containsHeader("X-SPDY-Stream-ID")) {
                SpdyHttpHeaders.setStreamId(response, id);
            }
        }
        super.writeRequested(ctx, e);
    }
}

