/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.xerial.snappy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public class OSInfo {
    private static HashMap<String, String> archMapping = new HashMap();
    public static final String X86 = "x86";
    public static final String X86_64 = "x86_64";
    public static final String IA64_32 = "ia64_32";
    public static final String IA64 = "ia64";
    public static final String PPC = "ppc";
    public static final String PPC64 = "ppc64";

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            if ("--os".equals(stringArray[0])) {
                System.out.print(OSInfo.getOSName());
                return;
            }
            if ("--arch".equals(stringArray[0])) {
                System.out.print(OSInfo.getArchName());
                return;
            }
        }
        System.out.print(OSInfo.getNativeLibFolderPathForCurrentOS());
    }

    public static String getNativeLibFolderPathForCurrentOS() {
        return OSInfo.getOSName() + "/" + OSInfo.getArchName();
    }

    public static String getOSName() {
        return OSInfo.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    public static String getArchName() {
        String string2 = System.getProperty("os.arch");
        if (string2.startsWith("arm") && System.getProperty("os.name").contains("Linux")) {
            String string3 = System.getProperty("java.home");
            try {
                String[] stringArray = new String[]{"/bin/sh", "-c", "find '" + string3 + "' -name 'libjvm.so' | head -1 | xargs readelf -A | " + "grep 'Tag_ABI_VFP_args: VFP registers'"};
                int n = Runtime.getRuntime().exec(stringArray).waitFor();
                if (n == 0) {
                    return "armhf";
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        } else {
            String string4 = string2.toLowerCase(Locale.US);
            if (archMapping.containsKey(string4)) {
                return archMapping.get(string4);
            }
        }
        return OSInfo.translateArchNameToFolderName(string2);
    }

    static String translateOSNameToFolderName(String string2) {
        if (string2.contains("Windows")) {
            return "Windows";
        }
        if (string2.contains("Mac")) {
            return "Mac";
        }
        if (string2.contains("Linux")) {
            return "Linux";
        }
        if (string2.contains("AIX")) {
            return "AIX";
        }
        return string2.replaceAll("\\W", "");
    }

    static String translateArchNameToFolderName(String string2) {
        return string2.replaceAll("\\W", "");
    }

    static {
        archMapping.put(X86, X86);
        archMapping.put("i386", X86);
        archMapping.put("i486", X86);
        archMapping.put("i586", X86);
        archMapping.put("i686", X86);
        archMapping.put("pentium", X86);
        archMapping.put(X86_64, X86_64);
        archMapping.put("amd64", X86_64);
        archMapping.put("em64t", X86_64);
        archMapping.put("universal", X86_64);
        archMapping.put(IA64, IA64);
        archMapping.put("ia64w", IA64);
        archMapping.put(IA64_32, IA64_32);
        archMapping.put("ia64n", IA64_32);
        archMapping.put(PPC, PPC);
        archMapping.put("power", PPC);
        archMapping.put("powerpc", PPC);
        archMapping.put("power_pc", PPC);
        archMapping.put("power_rs", PPC);
        archMapping.put(PPC64, PPC64);
        archMapping.put("power64", PPC64);
        archMapping.put("powerpc64", PPC64);
        archMapping.put("power_pc64", PPC64);
        archMapping.put("power_rs64", PPC64);
    }
}

