/*
 * Copyright 2012 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package org.graylog.shaded.kafka09.org.jboss.netty.handler.ssl;

import java.util.concurrent.Executor;

/**
 * {@link Executor} which executes the command in the caller thread.
 */
public final class ImmediateExecutor implements Executor {

    /**
     * The default instance.
     */
    public static final ImmediateExecutor INSTANCE = new ImmediateExecutor();

    public void execute(Runnable command) {
        command.run();
    }

    private ImmediateExecutor() {
        // should use static instance
    }
}
