/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.com.sun.mail.imap.protocol;

import java.io.IOException;
import java.util.Vector;
import org.graylog.shaded.kafka09.com.sun.mail.iap.ParsingException;
import org.graylog.shaded.kafka09.com.sun.mail.iap.Protocol;
import org.graylog.shaded.kafka09.com.sun.mail.iap.ProtocolException;
import org.graylog.shaded.kafka09.com.sun.mail.iap.Response;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.BODY;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.BODYSTRUCTURE;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.ENVELOPE;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.FLAGS;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.IMAPResponse;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.INTERNALDATE;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.Item;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.RFC822DATA;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.RFC822SIZE;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.UID;

public class FetchResponse
extends IMAPResponse {
    private Item[] items;
    private static final char[] HEADER = new char[]{'.', 'H', 'E', 'A', 'D', 'E', 'R'};
    private static final char[] TEXT = new char[]{'.', 'T', 'E', 'X', 'T'};

    public FetchResponse(Protocol p) throws IOException, ProtocolException {
        super(p);
        this.parse();
    }

    public FetchResponse(IMAPResponse r) throws IOException, ProtocolException {
        super(r);
        this.parse();
    }

    public int getItemCount() {
        return this.items.length;
    }

    public Item getItem(int index2) {
        return this.items[index2];
    }

    public Item getItem(Class c) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!c.isInstance(this.items[i])) continue;
            return this.items[i];
        }
        return null;
    }

    public static Item getItem(Response[] r, int msgno, Class c) {
        if (r == null) {
            return null;
        }
        for (int i = 0; i < r.length; ++i) {
            if (r[i] == null || !(r[i] instanceof FetchResponse) || ((FetchResponse)r[i]).getNumber() != msgno) continue;
            FetchResponse f = (FetchResponse)r[i];
            for (int j = 0; j < f.items.length; ++j) {
                if (!c.isInstance(f.items[j])) continue;
                return f.items[j];
            }
        }
        return null;
    }

    private void parse() throws ParsingException {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            throw new ParsingException("error in FETCH parsing, missing '(' at index " + this.index);
        }
        Vector<ENVELOPE> v = new Vector<ENVELOPE>();
        Item i = null;
        do {
            ++this.index;
            if (this.index >= this.size) {
                throw new ParsingException("error in FETCH parsing, ran off end of buffer, size " + this.size);
            }
            switch (this.buffer[this.index]) {
                case 69: {
                    if (!this.match(ENVELOPE.name)) break;
                    this.index += ENVELOPE.name.length;
                    i = new ENVELOPE(this);
                    break;
                }
                case 70: {
                    if (!this.match(FLAGS.name)) break;
                    this.index += FLAGS.name.length;
                    i = new FLAGS(this);
                    break;
                }
                case 73: {
                    if (!this.match(INTERNALDATE.name)) break;
                    this.index += INTERNALDATE.name.length;
                    i = new INTERNALDATE(this);
                    break;
                }
                case 66: {
                    if (!this.match(BODY.name)) break;
                    if (this.buffer[this.index + 4] == 91) {
                        this.index += BODY.name.length;
                        i = new BODY(this);
                        break;
                    }
                    this.index = this.match(BODYSTRUCTURE.name) ? (this.index += BODYSTRUCTURE.name.length) : (this.index += BODY.name.length);
                    i = new BODYSTRUCTURE(this);
                    break;
                }
                case 82: {
                    if (this.match(RFC822SIZE.name)) {
                        this.index += RFC822SIZE.name.length;
                        i = new RFC822SIZE(this);
                        break;
                    }
                    if (!this.match(RFC822DATA.name)) break;
                    this.index += RFC822DATA.name.length;
                    if (this.match(HEADER)) {
                        this.index += HEADER.length;
                    } else if (this.match(TEXT)) {
                        this.index += TEXT.length;
                    }
                    i = new RFC822DATA(this);
                    break;
                }
                case 85: {
                    if (!this.match(UID.name)) break;
                    this.index += UID.name.length;
                    i = new UID(this);
                    break;
                }
            }
            if (i == null) continue;
            v.addElement((ENVELOPE)i);
        } while (this.buffer[this.index] != 41);
        ++this.index;
        this.items = new Item[v.size()];
        v.copyInto(this.items);
    }

    private boolean match(char[] itemName) {
        int len = itemName.length;
        int i = 0;
        int j = this.index;
        while (i < len) {
            if (Character.toUpperCase((char)this.buffer[j++]) == itemName[i++]) continue;
            return false;
        }
        return true;
    }
}

