/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.com.sun.mail.imap.protocol;

import java.io.IOException;
import java.util.Vector;
import org.graylog.shaded.kafka09.com.sun.mail.iap.Protocol;
import org.graylog.shaded.kafka09.com.sun.mail.iap.ProtocolException;
import org.graylog.shaded.kafka09.com.sun.mail.iap.Response;
import org.graylog.shaded.kafka09.com.sun.mail.imap.protocol.FetchResponse;
import org.graylog.shaded.kafka09.com.sun.mail.util.ASCIIUtility;

public class IMAPResponse
extends Response {
    private String key;
    private int number;

    public IMAPResponse(Protocol c) throws IOException, ProtocolException {
        super(c);
        if (!(!this.isUnTagged() || this.isOK() || this.isNO() || this.isBAD() || this.isBYE())) {
            this.key = this.readAtom();
            try {
                this.number = Integer.parseInt(this.key);
                this.key = this.readAtom();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public IMAPResponse(IMAPResponse r) {
        super(r);
        this.key = r.key;
        this.number = r.number;
    }

    public String[] readSimpleList() {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            return null;
        }
        ++this.index;
        Vector<String> v = new Vector<String>();
        int start = this.index;
        while (this.buffer[this.index] != 41) {
            if (this.buffer[this.index] == 32) {
                v.addElement(ASCIIUtility.toString(this.buffer, start, this.index));
                start = this.index + 1;
            }
            ++this.index;
        }
        if (this.index > start) {
            v.addElement(ASCIIUtility.toString(this.buffer, start, this.index));
        }
        ++this.index;
        int size2 = v.size();
        if (size2 > 0) {
            Object[] s2 = new String[size2];
            v.copyInto(s2);
            return s2;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public boolean keyEquals(String k) {
        return this.key != null && this.key.equalsIgnoreCase(k);
    }

    public int getNumber() {
        return this.number;
    }

    public static IMAPResponse readResponse(Protocol p) throws IOException, ProtocolException {
        IMAPResponse r = new IMAPResponse(p);
        if (r.keyEquals("FETCH")) {
            r = new FetchResponse(r);
        }
        return r;
    }
}

