/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.com.sun.mail.smtp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.graylog.shaded.kafka09.com.sun.mail.util.ASCIIUtility;
import org.graylog.shaded.kafka09.com.sun.mail.util.BASE64DecoderStream;
import org.graylog.shaded.kafka09.com.sun.mail.util.BASE64EncoderStream;

public class DigestMD5 {
    private PrintStream debugout;
    private MessageDigest md5;
    private String uri;
    private String clientResponse;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestMD5(PrintStream debugout) {
        this.debugout = debugout;
        if (debugout != null) {
            debugout.println("DEBUG DIGEST-MD5: Loaded");
        }
    }

    public byte[] authClient(String host, String user, String passwd, String realm, String serverChallenge) throws IOException {
        SecureRandom random;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
        try {
            random = new SecureRandom();
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            if (this.debugout != null) {
                this.debugout.println("DEBUG DIGEST-MD5: " + ex);
            }
            throw new IOException(ex.toString());
        }
        StringBuffer result2 = new StringBuffer();
        this.uri = "smtp/" + host;
        String nc = "00000001";
        String qop = "auth";
        byte[] bytes = new byte[32];
        if (this.debugout != null) {
            this.debugout.println("DEBUG DIGEST-MD5: Begin authentication ...");
        }
        Hashtable map2 = this.tokenize(serverChallenge);
        if (realm == null) {
            String text2 = (String)map2.get("realm");
            realm = text2 != null ? new StringTokenizer(text2, ",").nextToken() : host;
        }
        String nonce = (String)map2.get("nonce");
        random.nextBytes(bytes);
        ((OutputStream)b64os).write(bytes);
        ((OutputStream)b64os).flush();
        String cnonce = bos.toString();
        bos.reset();
        this.md5.update(this.md5.digest(ASCIIUtility.getBytes(user + ":" + realm + ":" + passwd)));
        this.md5.update(ASCIIUtility.getBytes(":" + nonce + ":" + cnonce));
        this.clientResponse = DigestMD5.toHex(this.md5.digest()) + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":";
        this.md5.update(ASCIIUtility.getBytes("AUTHENTICATE:" + this.uri));
        this.md5.update(ASCIIUtility.getBytes(this.clientResponse + DigestMD5.toHex(this.md5.digest())));
        result2.append("username=\"" + user + "\"");
        result2.append(",realm=\"" + realm + "\"");
        result2.append(",qop=" + qop);
        result2.append(",nc=" + nc);
        result2.append(",nonce=\"" + nonce + "\"");
        result2.append(",cnonce=\"" + cnonce + "\"");
        result2.append(",digest-uri=\"" + this.uri + "\"");
        result2.append(",response=" + DigestMD5.toHex(this.md5.digest()));
        if (this.debugout != null) {
            this.debugout.println("DEBUG DIGEST-MD5: Response => " + result2.toString());
        }
        ((OutputStream)b64os).write(ASCIIUtility.getBytes(result2.toString()));
        ((OutputStream)b64os).flush();
        return bos.toByteArray();
    }

    public boolean authServer(String serverResponse) throws IOException {
        Hashtable map2 = this.tokenize(serverResponse);
        this.md5.update(ASCIIUtility.getBytes(":" + this.uri));
        this.md5.update(ASCIIUtility.getBytes(this.clientResponse + DigestMD5.toHex(this.md5.digest())));
        String text2 = DigestMD5.toHex(this.md5.digest());
        if (!text2.equals((String)map2.get("rspauth"))) {
            if (this.debugout != null) {
                this.debugout.println("DEBUG DIGEST-MD5: Expected => rspauth=" + text2);
            }
            return false;
        }
        return true;
    }

    private Hashtable tokenize(String serverResponse) throws IOException {
        int ttype;
        Hashtable<String, String> map2 = new Hashtable<String, String>();
        byte[] bytes = serverResponse.getBytes();
        String key = null;
        StreamTokenizer tokens = new StreamTokenizer(new InputStreamReader(new BASE64DecoderStream(new ByteArrayInputStream(bytes, 4, bytes.length - 4))));
        tokens.ordinaryChars(48, 57);
        tokens.wordChars(48, 57);
        while ((ttype = tokens.nextToken()) != -1) {
            switch (ttype) {
                case -3: {
                    if (key == null) {
                        key = tokens.sval;
                        break;
                    }
                }
                case 34: {
                    if (this.debugout != null) {
                        this.debugout.println("DEBUG DIGEST-MD5: Received => " + key + "='" + tokens.sval + "'");
                    }
                    if (map2.containsKey(key)) {
                        map2.put(key, map2.get(key) + "," + tokens.sval);
                    } else {
                        map2.put(key, tokens.sval);
                    }
                    key = null;
                }
            }
        }
        return map2;
    }

    private static String toHex(byte[] bytes) {
        char[] result2 = new char[bytes.length * 2];
        int i = 0;
        for (int index2 = 0; index2 < bytes.length; ++index2) {
            int temp = bytes[index2] & 0xFF;
            result2[i++] = digits[temp >> 4];
            result2[i++] = digits[temp & 0xF];
        }
        return new String(result2);
    }
}

