/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.kafka.admin;

import org.graylog.shaded.kafka09.joptsimple.ArgumentAcceptingOptionSpec;
import org.graylog.shaded.kafka09.joptsimple.OptionParser;
import org.graylog.shaded.kafka09.joptsimple.OptionSet;
import org.graylog.shaded.kafka09.joptsimple.OptionSpec;
import org.graylog.shaded.kafka09.kafka.admin.AdminOperationException;
import org.graylog.shaded.kafka09.kafka.admin.PreferredReplicaLeaderElectionCommand;
import org.graylog.shaded.kafka09.kafka.common.TopicAndPartition;
import org.graylog.shaded.kafka09.kafka.utils.CommandLineUtils$;
import org.graylog.shaded.kafka09.kafka.utils.CoreUtils$;
import org.graylog.shaded.kafka09.kafka.utils.Json$;
import org.graylog.shaded.kafka09.kafka.utils.Log4jController$;
import org.graylog.shaded.kafka09.kafka.utils.Logging;
import org.graylog.shaded.kafka09.kafka.utils.Logging$class;
import org.graylog.shaded.kafka09.kafka.utils.ZkUtils;
import org.graylog.shaded.kafka09.kafka.utils.ZkUtils$;
import org.graylog.shaded.kafka09.org.I0Itec.zkclient.ZkClient;
import org.graylog.shaded.kafka09.org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.graylog.shaded.kafka09.org.apache.kafka.common.security.JaasUtils;
import org.graylog.shaded.kafka09.org.apache.kafka.common.utils.Utils;
import org.graylog.shaded.kafka09.org.apache.log4j.Logger;
import org.graylog.shaded.kafka09.scala.Function0;
import org.graylog.shaded.kafka09.scala.MatchError;
import org.graylog.shaded.kafka09.scala.None$;
import org.graylog.shaded.kafka09.scala.Option;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Predef$ArrowAssoc$;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.Some;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.GenSet;
import org.graylog.shaded.kafka09.scala.collection.Iterable;
import org.graylog.shaded.kafka09.scala.collection.Map;
import org.graylog.shaded.kafka09.scala.collection.Map$;
import org.graylog.shaded.kafka09.scala.collection.Set$;
import org.graylog.shaded.kafka09.scala.collection.immutable.List;
import org.graylog.shaded.kafka09.scala.collection.immutable.List$;
import org.graylog.shaded.kafka09.scala.collection.immutable.Set;
import org.graylog.shaded.kafka09.scala.collection.immutable.StringOps;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.runtime.BoxedUnit;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class PreferredReplicaLeaderElectionCommand$
implements Logging {
    public static final PreferredReplicaLeaderElectionCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PreferredReplicaLeaderElectionCommand$ preferredReplicaLeaderElectionCommand$ = this;
        synchronized (preferredReplicaLeaderElectionCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> jsonFileOpt = parser.accepts("path-to-json-file", "The JSON file with the list of partitions for which preferred replica leader election should be done, in the following format - \n{\"partitions\":\n\t[{\"topic\": \"foo\", \"partition\": 1},\n\t {\"topic\": \"foobar\", \"partition\": 2}]\n}\nDefaults to all existing partitions").withRequiredArg().describedAs("list of partitions for which preferred replica leader election needs to be triggered").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> zkConnectOpt = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "This tool causes leadership for each partition to be transferred back to the 'preferred replica', it can be used to balance leadership among the servers.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt}));
        String zkConnect = options.valueOf(zkConnectOpt);
        ZkClient zkClient = null;
        ZkUtils zkUtils = null;
        try {
            try {
                zkClient = ZkUtils$.MODULE$.createZkClient(zkConnect, 30000, 30000);
                zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
                org.graylog.shaded.kafka09.scala.collection.Set<TopicAndPartition> partitionsForPreferredReplicaElection = options.has(jsonFileOpt) ? this.parsePreferredReplicaElectionData(Utils.readFileAsString(options.valueOf(jsonFileOpt))) : zkUtils.getAllPartitions();
                PreferredReplicaLeaderElectionCommand preferredReplicaElectionCommand = new PreferredReplicaLeaderElectionCommand(zkUtils, partitionsForPreferredReplicaElection);
                preferredReplicaElectionCommand.moveLeaderToPreferredReplica();
                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Successfully started preferred replica election for partitions %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partitionsForPreferredReplicaElection})));
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println("Failed to start preferred replica election");
                Predef$.MODULE$.println(Utils.stackTrace(throwable));
            }
        }
        finally {
            if (zkClient != null) {
                zkClient.close();
            }
        }
    }

    public Set<TopicAndPartition> parsePreferredReplicaElectionData(String jsonString) {
        Option<Object> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object m = some.x();
            Option option2 = ((Map)m).get("partitions");
            if (option2 instanceof Some) {
                GenSet genSet;
                Some some2 = (Some)option2;
                Object partitionsList = some2.x();
                List partitionsRaw = (List)partitionsList;
                List partitions = partitionsRaw.map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TopicAndPartition apply(Map<String, Object> p) {
                        String topic = (String)p.get("topic").get();
                        int partition2 = BoxesRunTime.unboxToInt(p.get("partition").get());
                        return new TopicAndPartition(topic, partition2);
                    }
                }, List$.MODULE$.canBuildFrom());
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                GenSet partitionsSet = partitions.toSet();
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Preferred replica election data contains duplicate partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatePartitions.mkString(",")})));
                }
                GenSet genSet2 = genSet = partitionsSet;
                return genSet2;
            }
            if (None$.MODULE$.equals(option2)) {
                throw new AdminOperationException("Preferred replica election data is empty");
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("Preferred replica election data is empty");
        }
        throw new MatchError(option);
    }

    public void writePreferredReplicaElectionData(ZkUtils zkUtils, org.graylog.shaded.kafka09.scala.collection.Set<TopicAndPartition> partitionsUndergoingPreferredReplicaElection) {
        String zkPath = ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath();
        org.graylog.shaded.kafka09.scala.collection.Set partitionsList = partitionsUndergoingPreferredReplicaElection.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(TopicAndPartition e) {
                return (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("topic"), e.topic()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partition"), BoxesRunTime.boxToInteger(e.partition()))}));
            }
        }, Set$.MODULE$.canBuildFrom());
        String jsonData = Json$.MODULE$.encode(Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partitions"), partitionsList)})));
        try {
            zkUtils.createPersistentPath(zkPath, jsonData, zkUtils.createPersistentPath$default$3());
            this.info((Function0<String>)((Object)new Serializable(jsonData){
                public static final long serialVersionUID = 0L;
                private final String jsonData$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Created preferred replica election path with %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.jsonData$1}));
                }
                {
                    this.jsonData$1 = jsonData$1;
                }
            }));
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            Set<TopicAndPartition> partitionsUndergoingPreferredReplicaElection2 = this.parsePreferredReplicaElectionData(zkUtils.readData(zkPath)._1());
            throw new AdminOperationException(new StringBuilder().append((Object)"Preferred replica leader election currently in progress for ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%s. Aborting operation")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partitionsUndergoingPreferredReplicaElection2}))).toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

