/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.kafka.tools;

import org.graylog.shaded.kafka09.joptsimple.ArgumentAcceptingOptionSpec;
import org.graylog.shaded.kafka09.joptsimple.OptionParser;
import org.graylog.shaded.kafka09.joptsimple.OptionSet;
import org.graylog.shaded.kafka09.joptsimple.OptionSpec;
import org.graylog.shaded.kafka09.kafka.api.OffsetRequest;
import org.graylog.shaded.kafka09.kafka.api.OffsetRequest$;
import org.graylog.shaded.kafka09.kafka.api.PartitionMetadata;
import org.graylog.shaded.kafka09.kafka.api.PartitionOffsetRequestInfo;
import org.graylog.shaded.kafka09.kafka.api.PartitionOffsetsResponse;
import org.graylog.shaded.kafka09.kafka.api.TopicMetadata;
import org.graylog.shaded.kafka09.kafka.client.ClientUtils$;
import org.graylog.shaded.kafka09.kafka.cluster.BrokerEndPoint;
import org.graylog.shaded.kafka09.kafka.common.TopicAndPartition;
import org.graylog.shaded.kafka09.kafka.consumer.SimpleConsumer;
import org.graylog.shaded.kafka09.kafka.utils.CommandLineUtils$;
import org.graylog.shaded.kafka09.kafka.utils.ToolsUtils$;
import org.graylog.shaded.kafka09.scala.Array$;
import org.graylog.shaded.kafka09.scala.Function1;
import org.graylog.shaded.kafka09.scala.MatchError;
import org.graylog.shaded.kafka09.scala.None$;
import org.graylog.shaded.kafka09.scala.Option;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Predef$ArrowAssoc$;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.Some;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.Seq;
import org.graylog.shaded.kafka09.scala.collection.Seq$;
import org.graylog.shaded.kafka09.scala.collection.Set;
import org.graylog.shaded.kafka09.scala.collection.immutable.Map;
import org.graylog.shaded.kafka09.scala.collection.immutable.StringOps;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.reflect.ClassTag$;
import org.graylog.shaded.kafka09.scala.runtime.BoxedUnit;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.scala.runtime.LongRef;

public final class GetOffsetShell$ {
    public static final GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo("", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Long> timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class);
        ArgumentAcceptingOptionSpec<Integer> nOffsetsOpt = parser.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting consumer offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt, timeOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = options.valueOf(brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<BrokerEndPoint> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        String topic = options.valueOf(topicOpt);
        String partitionList = options.valueOf(partitionOpt);
        LongRef time = LongRef.create(options.valueOf(timeOpt));
        int nOffsets = options.valueOf(nOffsetsOpt);
        int maxWaitMs = options.valueOf(maxWaitMsOpt);
        Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), metadataTargetBrokers, clientId, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
        if (topicsMetadata.size() != 1 || !((TopicMetadata)topicsMetadata.apply(false)).topic().equals(topic)) {
            System.err.println(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s,  probably the topic does not exist, run ")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic}))).append((Object)"org.graylog.shaded.kafka09.kafka-list-topic.sh to verify").toString());
            System.exit(1);
        }
        String string2 = partitionList;
        String string3 = "";
        Seq<Object> partitions = !(string2 != null ? !string2.equals(string3) : string3 != null) ? ((TopicMetadata)topicsMetadata.head()).partitionsMetadata().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(PartitionMetadata x$1) {
                return x$1.partitionId();
            }
        }, Seq$.MODULE$.canBuildFrom()) : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionList.split(",")).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSeq();
        partitions.foreach(new Serializable(clientId, topic, time, nOffsets, topicsMetadata){
            public static final long serialVersionUID = 0L;
            private final String clientId$1;
            private final String topic$1;
            private final LongRef time$1;
            private final int nOffsets$1;
            private final Seq topicsMetadata$1;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                Option<PartitionMetadata> option;
                block7: {
                    block6: {
                        block2: {
                            Option<BrokerEndPoint> option2;
                            block5: {
                                block4: {
                                    block3: {
                                        Option<PartitionMetadata> partitionMetadataOpt = ((TopicMetadata)this.topicsMetadata$1.head()).partitionsMetadata().find((Function1<PartitionMetadata, Object>)((Object)new Serializable(this, partitionId){
                                            public static final long serialVersionUID = 0L;
                                            private final int partitionId$1;

                                            public final boolean apply(PartitionMetadata x$3) {
                                                return x$3.partitionId() == this.partitionId$1;
                                            }
                                            {
                                                this.partitionId$1 = partitionId$1;
                                            }
                                        }));
                                        option = partitionMetadataOpt;
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        PartitionMetadata metadata = (PartitionMetadata)some.x();
                                        option2 = metadata.leader();
                                        if (!(option2 instanceof Some)) break block3;
                                        Some some2 = (Some)option2;
                                        BrokerEndPoint leader = (BrokerEndPoint)some2.x();
                                        SimpleConsumer consumer = new SimpleConsumer(leader.host(), leader.port(), 10000, 100000, this.clientId$1);
                                        TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$1, partitionId);
                                        OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicAndPartition), new PartitionOffsetRequestInfo(this.time$1.elem, this.nOffsets$1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                                        Seq<Object> offsets = ((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets();
                                        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s:%d:%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToInteger(partitionId), offsets.mkString(",")})));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    if (!None$.MODULE$.equals(option2)) break block5;
                                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not have a leader. Skip getting offsets")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block6;
                            }
                            throw new MatchError(option2);
                        }
                        if (!None$.MODULE$.equals(option)) break block7;
                        System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                this.clientId$1 = clientId$1;
                this.topic$1 = topic$1;
                this.time$1 = time$1;
                this.nOffsets$1 = nOffsets$1;
                this.topicsMetadata$1 = topicsMetadata$1;
            }
        });
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

