/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.ApiKeys;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.Errors;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.ProtoUtils;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Schema;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Struct;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.AbstractRequest;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.AbstractRequestResponse;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.SyncGroupResponse;

public class SyncGroupRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.SYNC_GROUP.id);
    public static final String GROUP_ID_KEY_NAME = "group_id";
    public static final String GENERATION_ID_KEY_NAME = "generation_id";
    public static final String MEMBER_ID_KEY_NAME = "member_id";
    public static final String MEMBER_ASSIGNMENT_KEY_NAME = "member_assignment";
    public static final String GROUP_ASSIGNMENT_KEY_NAME = "group_assignment";
    private final String groupId;
    private final int generationId;
    private final String memberId;
    private final Map<String, ByteBuffer> groupAssignment;

    public SyncGroupRequest(String groupId, int generationId, String memberId, Map<String, ByteBuffer> groupAssignment) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        this.struct.set(GENERATION_ID_KEY_NAME, (Object)generationId);
        this.struct.set(MEMBER_ID_KEY_NAME, (Object)memberId);
        ArrayList<Struct> memberArray = new ArrayList<Struct>();
        for (Map.Entry<String, ByteBuffer> entries : groupAssignment.entrySet()) {
            Struct memberData = this.struct.instance(GROUP_ASSIGNMENT_KEY_NAME);
            memberData.set(MEMBER_ID_KEY_NAME, (Object)entries.getKey());
            memberData.set(MEMBER_ASSIGNMENT_KEY_NAME, (Object)entries.getValue());
            memberArray.add(memberData);
        }
        this.struct.set(GROUP_ASSIGNMENT_KEY_NAME, (Object)memberArray.toArray());
        this.groupId = groupId;
        this.generationId = generationId;
        this.memberId = memberId;
        this.groupAssignment = groupAssignment;
    }

    public SyncGroupRequest(Struct struct) {
        super(struct);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.generationId = struct.getInt(GENERATION_ID_KEY_NAME);
        this.memberId = struct.getString(MEMBER_ID_KEY_NAME);
        this.groupAssignment = new HashMap<String, ByteBuffer>();
        for (Object memberDataObj : struct.getArray(GROUP_ASSIGNMENT_KEY_NAME)) {
            Struct memberData = (Struct)memberDataObj;
            String memberId = memberData.getString(MEMBER_ID_KEY_NAME);
            ByteBuffer memberMetadata = memberData.getBytes(MEMBER_ASSIGNMENT_KEY_NAME);
            this.groupAssignment.put(memberId, memberMetadata);
        }
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                return new SyncGroupResponse(Errors.forException(e).code(), ByteBuffer.wrap(new byte[0]));
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.JOIN_GROUP.id)));
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public Map<String, ByteBuffer> groupAssignment() {
        return this.groupAssignment;
    }

    public String memberId() {
        return this.memberId;
    }

    public static SyncGroupRequest parse(ByteBuffer buffer, int versionId) {
        return new SyncGroupRequest(ProtoUtils.parseRequest(ApiKeys.SYNC_GROUP.id, versionId, buffer));
    }
}

