/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.log4j.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import org.graylog.shaded.kafka09.javax.xml.parsers.DocumentBuilder;
import org.graylog.shaded.kafka09.javax.xml.parsers.DocumentBuilderFactory;
import org.graylog.shaded.kafka09.javax.xml.parsers.FactoryConfigurationError;
import org.graylog.shaded.kafka09.org.apache.log4j.Appender;
import org.graylog.shaded.kafka09.org.apache.log4j.Layout;
import org.graylog.shaded.kafka09.org.apache.log4j.Level;
import org.graylog.shaded.kafka09.org.apache.log4j.LogManager;
import org.graylog.shaded.kafka09.org.apache.log4j.Logger;
import org.graylog.shaded.kafka09.org.apache.log4j.config.PropertySetter;
import org.graylog.shaded.kafka09.org.apache.log4j.helpers.Loader;
import org.graylog.shaded.kafka09.org.apache.log4j.helpers.LogLog;
import org.graylog.shaded.kafka09.org.apache.log4j.helpers.OptionConverter;
import org.graylog.shaded.kafka09.org.apache.log4j.or.RendererMap;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.AppenderAttachable;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.Configurator;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.Filter;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.LoggerFactory;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.LoggerRepository;
import org.graylog.shaded.kafka09.org.apache.log4j.spi.RendererSupport;
import org.graylog.shaded.kafka09.org.apache.log4j.xml.Log4jEntityResolver;
import org.graylog.shaded.kafka09.org.apache.log4j.xml.SAXErrorHandler;
import org.graylog.shaded.kafka09.org.apache.log4j.xml.UnrecognizedElementHandler;
import org.graylog.shaded.kafka09.org.apache.log4j.xml.XMLWatchdog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMConfigurator
implements Configurator {
    static final String CONFIGURATION_TAG = "log4j:configuration";
    static final String OLD_CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String LOGGER = "logger";
    static final String LOGGER_REF = "logger-ref";
    static final String CATEGORY_FACTORY_TAG = "categoryFactory";
    static final String LOGGER_FACTORY_TAG = "loggerFactory";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String ROOT_REF = "root-ref";
    static final String LEVEL_TAG = "level";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String THRESHOLD_ATTR = "threshold";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String INTERNAL_DEBUG_ATTR = "debug";
    private static final String RESET_ATTR = "reset";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DOMConfigurator.class$("java.lang.String")) : class$java$lang$String};
    static final String dbfKey = "org.graylog.shaded.kafka09.javax.xml.parsers.DocumentBuilderFactory";
    Hashtable appenderBag = new Hashtable();
    Properties props;
    LoggerRepository repository;
    protected LoggerFactory catFactory = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$spi$ErrorHandler;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;
    static /* synthetic */ Class class$org$apache$log4j$spi$LoggerFactory;

    protected Appender findAppenderByName(Document doc, String appenderName) {
        Appender appender = (Appender)this.appenderBag.get(appenderName);
        if (appender != null) {
            return appender;
        }
        Element element = null;
        NodeList list2 = doc.getElementsByTagName(APPENDER_TAG);
        for (int t = 0; t < list2.getLength(); ++t) {
            Node node = list2.item(t);
            NamedNodeMap map2 = node.getAttributes();
            Node attrNode = map2.getNamedItem(NAME_ATTR);
            if (!appenderName.equals(attrNode.getNodeValue())) continue;
            element = (Element)node;
            break;
        }
        if (element == null) {
            LogLog.error("No appender named [" + appenderName + "] could be found.");
            return null;
        }
        appender = this.parseAppender(element);
        this.appenderBag.put(appenderName, appender);
        return appender;
    }

    protected Appender findAppenderByReference(Element appenderRef) {
        String appenderName = this.subst(appenderRef.getAttribute(REF_ATTR));
        Document doc = appenderRef.getOwnerDocument();
        return this.findAppenderByName(doc, appenderName);
    }

    private static void parseUnrecognizedElement(Object instance, Element element, Properties props) throws Exception {
        boolean recognized = false;
        if (instance instanceof UnrecognizedElementHandler) {
            recognized = ((UnrecognizedElementHandler)instance).parseUnrecognizedElement(element, props);
        }
        if (!recognized) {
            LogLog.warn("Unrecognized element " + element.getNodeName());
        }
    }

    private static void quietParseUnrecognizedElement(Object instance, Element element, Properties props) {
        try {
            DOMConfigurator.parseUnrecognizedElement(instance, element, props);
        }
        catch (Exception ex) {
            LogLog.error("Error in extension content: ", ex);
        }
    }

    protected Appender parseAppender(Element appenderElement) {
        String className = this.subst(appenderElement.getAttribute(CLASS_ATTR));
        LogLog.debug("Class name: [" + className + ']');
        try {
            Object instance = Loader.loadClass(className).newInstance();
            Appender appender = (Appender)instance;
            PropertySetter propSetter = new PropertySetter(appender);
            appender.setName(this.subst(appenderElement.getAttribute(NAME_ATTR)));
            NodeList children = appenderElement.getChildNodes();
            int length = children.getLength();
            for (int loop2 = 0; loop2 < length; ++loop2) {
                Node currentNode = children.item(loop2);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                if (currentElement.getTagName().equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                if (currentElement.getTagName().equals(LAYOUT_TAG)) {
                    appender.setLayout(this.parseLayout(currentElement));
                    continue;
                }
                if (currentElement.getTagName().equals(FILTER_TAG)) {
                    this.parseFilters(currentElement, appender);
                    continue;
                }
                if (currentElement.getTagName().equals(ERROR_HANDLER_TAG)) {
                    this.parseErrorHandler(currentElement, appender);
                    continue;
                }
                if (currentElement.getTagName().equals(APPENDER_REF_TAG)) {
                    String refName = this.subst(currentElement.getAttribute(REF_ATTR));
                    if (appender instanceof AppenderAttachable) {
                        AppenderAttachable aa = (AppenderAttachable)((Object)appender);
                        LogLog.debug("Attaching appender named [" + refName + "] to appender named [" + appender.getName() + "].");
                        aa.addAppender(this.findAppenderByReference(currentElement));
                        continue;
                    }
                    LogLog.error("Requesting attachment of appender named [" + refName + "] to appender named [" + appender.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
                    continue;
                }
                DOMConfigurator.parseUnrecognizedElement(instance, currentElement, this.props);
            }
            propSetter.activate();
            return appender;
        }
        catch (Exception oops) {
            LogLog.error("Could not create an Appender. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseErrorHandler(Element element, Appender appender) {
        org.graylog.shaded.kafka09.org.apache.log4j.spi.ErrorHandler eh = (org.graylog.shaded.kafka09.org.apache.log4j.spi.ErrorHandler)OptionConverter.instantiateByClassName(this.subst(element.getAttribute(CLASS_ATTR)), class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = DOMConfigurator.class$("org.graylog.shaded.kafka09.org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler, null);
        if (eh != null) {
            eh.setAppender(appender);
            PropertySetter propSetter = new PropertySetter(eh);
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            for (int loop2 = 0; loop2 < length; ++loop2) {
                Node currentNode = children.item(loop2);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                if (tagName.equals(APPENDER_REF_TAG)) {
                    eh.setBackupAppender(this.findAppenderByReference(currentElement));
                    continue;
                }
                if (tagName.equals(LOGGER_REF)) {
                    String loggerName = currentElement.getAttribute(REF_ATTR);
                    Logger logger = this.catFactory == null ? this.repository.getLogger(loggerName) : this.repository.getLogger(loggerName, this.catFactory);
                    eh.setLogger(logger);
                    continue;
                }
                if (tagName.equals(ROOT_REF)) {
                    Logger root2 = this.repository.getRootLogger();
                    eh.setLogger(root2);
                    continue;
                }
                DOMConfigurator.quietParseUnrecognizedElement(eh, currentElement, this.props);
            }
            propSetter.activate();
            appender.setErrorHandler(eh);
        }
    }

    protected void parseFilters(Element element, Appender appender) {
        String clazz = this.subst(element.getAttribute(CLASS_ATTR));
        Filter filter2 = (Filter)OptionConverter.instantiateByClassName(clazz, class$org$apache$log4j$spi$Filter == null ? (class$org$apache$log4j$spi$Filter = DOMConfigurator.class$("org.graylog.shaded.kafka09.org.apache.log4j.spi.Filter")) : class$org$apache$log4j$spi$Filter, null);
        if (filter2 != null) {
            PropertySetter propSetter = new PropertySetter(filter2);
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            for (int loop2 = 0; loop2 < length; ++loop2) {
                Node currentNode = children.item(loop2);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                DOMConfigurator.quietParseUnrecognizedElement(filter2, currentElement, this.props);
            }
            propSetter.activate();
            LogLog.debug("Adding filter of type [" + filter2.getClass() + "] to appender named [" + appender.getName() + "].");
            appender.addFilter(filter2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCategory(Element loggerElement) {
        Logger cat2;
        String catName = this.subst(loggerElement.getAttribute(NAME_ATTR));
        String className = this.subst(loggerElement.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(className)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Logger.");
            cat2 = this.catFactory == null ? this.repository.getLogger(catName) : this.repository.getLogger(catName, this.catFactory);
        } else {
            LogLog.debug("Desired logger sub-class: [" + className + ']');
            try {
                Class clazz = Loader.loadClass(className);
                Method getInstanceMethod = clazz.getMethod("getLogger", ONE_STRING_PARAM);
                cat2 = (Logger)getInstanceMethod.invoke(null, catName);
            }
            catch (Exception oops) {
                LogLog.error("Could not retrieve category [" + catName + "]. Reported error follows.", oops);
                return;
            }
        }
        Logger logger = cat2;
        synchronized (logger) {
            boolean additivity = OptionConverter.toBoolean(this.subst(loggerElement.getAttribute(ADDITIVITY_ATTR)), true);
            LogLog.debug("Setting [" + cat2.getName() + "] additivity to [" + additivity + "].");
            cat2.setAdditivity(additivity);
            this.parseChildrenOfLoggerElement(loggerElement, cat2, false);
        }
    }

    protected void parseCategoryFactory(Element factoryElement) {
        String className = this.subst(factoryElement.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(className)) {
            LogLog.error("Category Factory tag class attribute not found.");
            LogLog.debug("No Category Factory configured.");
        } else {
            LogLog.debug("Desired category factory: [" + className + ']');
            Object factory = OptionConverter.instantiateByClassName(className, class$org$apache$log4j$spi$LoggerFactory == null ? (class$org$apache$log4j$spi$LoggerFactory = DOMConfigurator.class$("org.graylog.shaded.kafka09.org.apache.log4j.spi.LoggerFactory")) : class$org$apache$log4j$spi$LoggerFactory, null);
            if (factory instanceof LoggerFactory) {
                this.catFactory = (LoggerFactory)factory;
            } else {
                LogLog.error("Category Factory class " + className + " does not implement org.apache.log4j.LoggerFactory");
            }
            PropertySetter propSetter = new PropertySetter(factory);
            Element currentElement = null;
            Node currentNode = null;
            NodeList children = factoryElement.getChildNodes();
            int length = children.getLength();
            for (int loop2 = 0; loop2 < length; ++loop2) {
                currentNode = children.item(loop2);
                if (currentNode.getNodeType() != 1) continue;
                currentElement = (Element)currentNode;
                if (currentElement.getTagName().equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                DOMConfigurator.quietParseUnrecognizedElement(factory, currentElement, this.props);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRoot(Element rootElement) {
        Logger root2;
        Logger logger = root2 = this.repository.getRootLogger();
        synchronized (logger) {
            this.parseChildrenOfLoggerElement(rootElement, root2, true);
        }
    }

    protected void parseChildrenOfLoggerElement(Element catElement, Logger cat2, boolean isRoot) {
        PropertySetter propSetter = new PropertySetter(cat2);
        cat2.removeAllAppenders();
        NodeList children = catElement.getChildNodes();
        int length = children.getLength();
        for (int loop2 = 0; loop2 < length; ++loop2) {
            Node currentNode = children.item(loop2);
            if (currentNode.getNodeType() != 1) continue;
            Element currentElement = (Element)currentNode;
            String tagName = currentElement.getTagName();
            if (tagName.equals(APPENDER_REF_TAG)) {
                Element appenderRef = (Element)currentNode;
                Appender appender = this.findAppenderByReference(appenderRef);
                String refName = this.subst(appenderRef.getAttribute(REF_ATTR));
                if (appender != null) {
                    LogLog.debug("Adding appender named [" + refName + "] to category [" + cat2.getName() + "].");
                } else {
                    LogLog.debug("Appender named [" + refName + "] not found.");
                }
                cat2.addAppender(appender);
                continue;
            }
            if (tagName.equals(LEVEL_TAG)) {
                this.parseLevel(currentElement, cat2, isRoot);
                continue;
            }
            if (tagName.equals(PRIORITY_TAG)) {
                this.parseLevel(currentElement, cat2, isRoot);
                continue;
            }
            if (tagName.equals(PARAM_TAG)) {
                this.setParameter(currentElement, propSetter);
                continue;
            }
            DOMConfigurator.quietParseUnrecognizedElement(cat2, currentElement, this.props);
        }
        propSetter.activate();
    }

    protected Layout parseLayout(Element layout_element) {
        String className = this.subst(layout_element.getAttribute(CLASS_ATTR));
        LogLog.debug("Parsing layout of class: \"" + className + "\"");
        try {
            Object instance = Loader.loadClass(className).newInstance();
            Layout layout = (Layout)instance;
            PropertySetter propSetter = new PropertySetter(layout);
            NodeList params = layout_element.getChildNodes();
            int length = params.getLength();
            for (int loop2 = 0; loop2 < length; ++loop2) {
                Node currentNode = params.item(loop2);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                DOMConfigurator.parseUnrecognizedElement(instance, currentElement, this.props);
            }
            propSetter.activate();
            return layout;
        }
        catch (Exception oops) {
            LogLog.error("Could not create the Layout. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseRenderer(Element element) {
        String renderingClass = this.subst(element.getAttribute(RENDERING_CLASS_ATTR));
        String renderedClass = this.subst(element.getAttribute(RENDERED_CLASS_ATTR));
        if (this.repository instanceof RendererSupport) {
            RendererMap.addRenderer((RendererSupport)((Object)this.repository), renderedClass, renderingClass);
        }
    }

    protected void parseLevel(Element element, Logger logger, boolean isRoot) {
        String catName = logger.getName();
        if (isRoot) {
            catName = ROOT_TAG;
        }
        String priStr = this.subst(element.getAttribute(VALUE_ATTR));
        LogLog.debug("Level value for " + catName + " is  [" + priStr + "].");
        if ("inherited".equalsIgnoreCase(priStr) || "null".equalsIgnoreCase(priStr)) {
            if (isRoot) {
                LogLog.error("Root level cannot be inherited. Ignoring directive.");
            } else {
                logger.setLevel(null);
            }
        } else {
            String className = this.subst(element.getAttribute(CLASS_ATTR));
            if (EMPTY_STR.equals(className)) {
                logger.setLevel(OptionConverter.toLevel(priStr, Level.DEBUG));
            } else {
                LogLog.debug("Desired Level sub-class: [" + className + ']');
                try {
                    Class clazz = Loader.loadClass(className);
                    Method toLevelMethod = clazz.getMethod("toLevel", ONE_STRING_PARAM);
                    Level pri = (Level)toLevelMethod.invoke(null, priStr);
                    logger.setLevel(pri);
                }
                catch (Exception oops) {
                    LogLog.error("Could not create level [" + priStr + "]. Reported error follows.", oops);
                    return;
                }
            }
        }
        LogLog.debug(catName + " level set to " + logger.getLevel());
    }

    protected void setParameter(Element elem2, PropertySetter propSetter) {
        DOMConfigurator.setParameter(elem2, propSetter, this.props);
    }

    public static void configure(Element element) {
        DOMConfigurator configurator = new DOMConfigurator();
        configurator.doConfigure(element, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String configFilename) {
        DOMConfigurator.configureAndWatch(configFilename, 60000L);
    }

    public static void configureAndWatch(String configFilename, long delay) {
        XMLWatchdog xdog = new XMLWatchdog(configFilename);
        xdog.setDelay(delay);
        xdog.start();
    }

    public void doConfigure(final String filename, LoggerRepository repository) {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(new File(filename));
            }

            public String toString() {
                return "file [" + filename + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    public void doConfigure(final URL url, LoggerRepository repository) {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(url.toString());
            }

            public String toString() {
                return "url [" + url.toString() + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    public void doConfigure(final InputStream inputStream, LoggerRepository repository) throws FactoryConfigurationError {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId("dummy://log4j.dtd");
                return parser.parse(inputSource);
            }

            public String toString() {
                return "input stream [" + inputStream.toString() + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    public void doConfigure(final Reader reader, LoggerRepository repository) throws FactoryConfigurationError {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                InputSource inputSource = new InputSource(reader);
                inputSource.setSystemId("dummy://log4j.dtd");
                return parser.parse(inputSource);
            }

            public String toString() {
                return "reader [" + reader.toString() + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    protected void doConfigure(final InputSource inputSource, LoggerRepository repository) throws FactoryConfigurationError {
        if (inputSource.getSystemId() == null) {
            inputSource.setSystemId("dummy://log4j.dtd");
        }
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(inputSource);
            }

            public String toString() {
                return "input source [" + inputSource.toString() + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    private final void doConfigure(ParseAction action, LoggerRepository repository) throws FactoryConfigurationError {
        DocumentBuilderFactory dbf = null;
        this.repository = repository;
        try {
            LogLog.debug("System property is :" + OptionConverter.getSystemProperty(dbfKey, null));
            dbf = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug("DocumentBuilderFactory is: " + dbf.getClass().getName());
        }
        catch (FactoryConfigurationError fce) {
            Exception e = fce.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", e);
            throw fce;
        }
        try {
            dbf.setValidating(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            docBuilder.setErrorHandler((ErrorHandler)new SAXErrorHandler());
            docBuilder.setEntityResolver((EntityResolver)new Log4jEntityResolver());
            Document doc = action.parse(docBuilder);
            this.parse(doc.getDocumentElement());
        }
        catch (Exception e) {
            LogLog.error("Could not parse " + action.toString() + ".", e);
        }
    }

    public void doConfigure(Element element, LoggerRepository repository) {
        this.repository = repository;
        this.parse(element);
    }

    public static void configure(String filename) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(filename, LogManager.getLoggerRepository());
    }

    public static void configure(URL url) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(url, LogManager.getLoggerRepository());
    }

    protected void parse(Element element) {
        int loop2;
        String confDebug;
        String rootElementName = element.getTagName();
        if (!rootElementName.equals(CONFIGURATION_TAG)) {
            if (rootElementName.equals(OLD_CONFIGURATION_TAG)) {
                LogLog.warn("The <configuration> element has been deprecated.");
                LogLog.warn("Use the <log4j:configuration> element instead.");
            } else {
                LogLog.error("DOM element is - not a <log4j:configuration> element.");
                return;
            }
        }
        String debugAttrib = this.subst(element.getAttribute(INTERNAL_DEBUG_ATTR));
        LogLog.debug("debug attribute= \"" + debugAttrib + "\".");
        if (!debugAttrib.equals(EMPTY_STR) && !debugAttrib.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(debugAttrib, true));
        } else {
            LogLog.debug("Ignoring debug attribute.");
        }
        String resetAttrib = this.subst(element.getAttribute(RESET_ATTR));
        LogLog.debug("reset attribute= \"" + resetAttrib + "\".");
        if (!EMPTY_STR.equals(resetAttrib) && OptionConverter.toBoolean(resetAttrib, false)) {
            this.repository.resetConfiguration();
        }
        if (!(confDebug = this.subst(element.getAttribute(CONFIG_DEBUG_ATTR))).equals(EMPTY_STR) && !confDebug.equals("null")) {
            LogLog.warn("The \"configDebug\" attribute is deprecated.");
            LogLog.warn("Use the \"debug\" attribute instead.");
            LogLog.setInternalDebugging(OptionConverter.toBoolean(confDebug, true));
        }
        String thresholdStr = this.subst(element.getAttribute(THRESHOLD_ATTR));
        LogLog.debug("Threshold =\"" + thresholdStr + "\".");
        if (!EMPTY_STR.equals(thresholdStr) && !"null".equals(thresholdStr)) {
            this.repository.setThreshold(thresholdStr);
        }
        String tagName = null;
        Element currentElement = null;
        Node currentNode = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (loop2 = 0; loop2 < length; ++loop2) {
            currentNode = children.item(loop2);
            if (currentNode.getNodeType() != 1 || !(tagName = (currentElement = (Element)currentNode).getTagName()).equals(CATEGORY_FACTORY_TAG) && !tagName.equals(LOGGER_FACTORY_TAG)) continue;
            this.parseCategoryFactory(currentElement);
        }
        for (loop2 = 0; loop2 < length; ++loop2) {
            currentNode = children.item(loop2);
            if (currentNode.getNodeType() != 1) continue;
            currentElement = (Element)currentNode;
            tagName = currentElement.getTagName();
            if (tagName.equals(CATEGORY) || tagName.equals(LOGGER)) {
                this.parseCategory(currentElement);
                continue;
            }
            if (tagName.equals(ROOT_TAG)) {
                this.parseRoot(currentElement);
                continue;
            }
            if (tagName.equals(RENDERER_TAG)) {
                this.parseRenderer(currentElement);
                continue;
            }
            if (tagName.equals(APPENDER_TAG) || tagName.equals(CATEGORY_FACTORY_TAG) || tagName.equals(LOGGER_FACTORY_TAG)) continue;
            DOMConfigurator.quietParseUnrecognizedElement(this.repository, currentElement, this.props);
        }
    }

    protected String subst(String value2) {
        return DOMConfigurator.subst(value2, this.props);
    }

    public static String subst(String value2, Properties props) {
        try {
            return OptionConverter.substVars(value2, props);
        }
        catch (IllegalArgumentException e) {
            LogLog.warn("Could not perform variable substitution.", e);
            return value2;
        }
    }

    public static void setParameter(Element elem2, PropertySetter propSetter, Properties props) {
        String name = DOMConfigurator.subst(elem2.getAttribute(NAME_ATTR), props);
        String value2 = elem2.getAttribute(VALUE_ATTR);
        value2 = DOMConfigurator.subst(OptionConverter.convertSpecialChars(value2), props);
        propSetter.setProperty(name, value2);
    }

    public static Object parseElement(Element element, Properties props, Class expectedClass) throws Exception {
        String clazz = DOMConfigurator.subst(element.getAttribute(CLASS_ATTR), props);
        Object instance = OptionConverter.instantiateByClassName(clazz, expectedClass, null);
        if (instance != null) {
            PropertySetter propSetter = new PropertySetter(instance);
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            for (int loop2 = 0; loop2 < length; ++loop2) {
                Node currentNode = children.item(loop2);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals(PARAM_TAG)) {
                    DOMConfigurator.setParameter(currentElement, propSetter, props);
                    continue;
                }
                DOMConfigurator.parseUnrecognizedElement(instance, currentElement, props);
            }
            return instance;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface ParseAction {
        public Document parse(DocumentBuilder var1) throws SAXException, IOException;
    }
}

