/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.zookeeper;

import org.graylog.shaded.kafka09.org.apache.zookeeper.KeeperException;
import org.graylog.shaded.kafka09.org.slf4j.Logger;
import org.graylog.shaded.kafka09.org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CreateMode {
    PERSISTENT(0, false, false),
    PERSISTENT_SEQUENTIAL(2, false, true),
    EPHEMERAL(1, true, false),
    EPHEMERAL_SEQUENTIAL(3, true, true);

    private static final Logger LOG;
    private boolean ephemeral;
    private boolean sequential;
    private int flag;

    private CreateMode(int flag, boolean ephemeral, boolean sequential) {
        this.flag = flag;
        this.ephemeral = ephemeral;
        this.sequential = sequential;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public int toFlag() {
        return this.flag;
    }

    public static CreateMode fromFlag(int flag) throws KeeperException {
        switch (flag) {
            case 0: {
                return PERSISTENT;
            }
            case 1: {
                return EPHEMERAL;
            }
            case 2: {
                return PERSISTENT_SEQUENTIAL;
            }
            case 3: {
                return EPHEMERAL_SEQUENTIAL;
            }
        }
        String errMsg = "Received an invalid flag value: " + flag + " to convert to a CreateMode";
        LOG.error(errMsg);
        throw new KeeperException.BadArgumentsException(errMsg);
    }

    static {
        LOG = LoggerFactory.getLogger(CreateMode.class);
    }
}

