/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.graylog.shaded.kafka09.org.jboss.netty.buffer.ChannelBuffer;
import org.graylog.shaded.kafka09.org.jboss.netty.buffer.ChannelBuffers;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.http.HttpConstants;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.codec.http.multipart.AbstractHttpData;

public abstract class AbstractDiskHttpData
extends AbstractHttpData {
    protected File file;
    private boolean isRenamed;
    private FileChannel fileChannel;

    protected AbstractDiskHttpData(String name, Charset charset, long size2) {
        super(name, charset, size2);
    }

    protected abstract String getDiskFilename();

    protected abstract String getPrefix();

    protected abstract String getBaseDirectory();

    protected abstract String getPostfix();

    protected abstract boolean deleteOnExit();

    private File tempFile() throws IOException {
        String diskFilename = this.getDiskFilename();
        String newpostfix = diskFilename != null ? '_' + diskFilename : this.getPostfix();
        File tmpFile = this.getBaseDirectory() == null ? File.createTempFile(this.getPrefix(), newpostfix) : File.createTempFile(this.getPrefix(), newpostfix, new File(this.getBaseDirectory()));
        if (this.deleteOnExit()) {
            tmpFile.deleteOnExit();
        }
        return tmpFile;
    }

    public void setContent(ChannelBuffer buffer) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.size = buffer.readableBytes();
        if (this.definedSize > 0L && this.definedSize < this.size) {
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        if (this.file == null) {
            this.file = this.tempFile();
        }
        if (buffer.readableBytes() == 0) {
            this.file.createNewFile();
            return;
        }
        FileOutputStream outputStream = new FileOutputStream(this.file);
        FileChannel localfileChannel = outputStream.getChannel();
        ByteBuffer byteBuffer = buffer.toByteBuffer();
        int written = 0;
        while ((long)written < this.size) {
            written += localfileChannel.write(byteBuffer);
        }
        buffer.readerIndex(buffer.readerIndex() + written);
        localfileChannel.force(false);
        localfileChannel.close();
        outputStream.close();
        this.completed = true;
    }

    public void addContent(ChannelBuffer buffer, boolean last2) throws IOException {
        if (buffer != null) {
            int localsize = buffer.readableBytes();
            if (this.definedSize > 0L && this.definedSize < this.size + (long)localsize) {
                throw new IOException("Out of size: " + (this.size + (long)localsize) + " > " + this.definedSize);
            }
            ByteBuffer byteBuffer = buffer.toByteBuffer();
            int written = 0;
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (this.fileChannel == null) {
                FileOutputStream outputStream = new FileOutputStream(this.file);
                this.fileChannel = outputStream.getChannel();
            }
            while (written < localsize) {
                written += this.fileChannel.write(byteBuffer);
            }
            this.size += (long)localsize;
            buffer.readerIndex(buffer.readerIndex() + written);
        }
        if (last2) {
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (this.fileChannel == null) {
                FileOutputStream outputStream = new FileOutputStream(this.file);
                this.fileChannel = outputStream.getChannel();
            }
            this.fileChannel.force(false);
            this.fileChannel.close();
            this.fileChannel = null;
            this.completed = true;
        } else if (buffer == null) {
            throw new NullPointerException("buffer");
        }
    }

    public void setContent(File file) throws IOException {
        if (this.file != null) {
            this.delete();
        }
        this.file = file;
        this.size = file.length();
        this.isRenamed = true;
        this.completed = true;
    }

    public void setContent(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (this.file != null) {
            this.delete();
        }
        this.file = this.tempFile();
        FileOutputStream outputStream = new FileOutputStream(this.file);
        FileChannel localfileChannel = outputStream.getChannel();
        byte[] bytes = new byte[16384];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int read2 = inputStream.read(bytes);
        int written = 0;
        while (read2 > 0) {
            byteBuffer.position(read2).flip();
            written += localfileChannel.write(byteBuffer);
            read2 = inputStream.read(bytes);
        }
        localfileChannel.force(false);
        localfileChannel.close();
        this.size = written;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            this.file.delete();
            this.file = null;
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        this.isRenamed = true;
        this.completed = true;
    }

    public void delete() {
        if (!this.isRenamed && this.file != null) {
            this.file.delete();
        }
    }

    public byte[] get() throws IOException {
        if (this.file == null) {
            return new byte[0];
        }
        return AbstractDiskHttpData.readFrom(this.file);
    }

    public ChannelBuffer getChannelBuffer() throws IOException {
        if (this.file == null) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        byte[] array = AbstractDiskHttpData.readFrom(this.file);
        return ChannelBuffers.wrappedBuffer(array);
    }

    public ChannelBuffer getChunk(int length) throws IOException {
        int read2;
        int readnow;
        if (this.file == null || length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (this.fileChannel == null) {
            FileInputStream inputStream = new FileInputStream(this.file);
            this.fileChannel = inputStream.getChannel();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        for (read2 = 0; read2 < length; read2 += readnow) {
            readnow = this.fileChannel.read(byteBuffer);
            if (readnow != -1) continue;
            this.fileChannel.close();
            this.fileChannel = null;
            break;
        }
        if (read2 == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        byteBuffer.flip();
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer(byteBuffer);
        buffer.readerIndex(0);
        buffer.writerIndex(read2);
        return buffer;
    }

    public String getString() throws IOException {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    public String getString(Charset encoding) throws IOException {
        if (this.file == null) {
            return "";
        }
        if (encoding == null) {
            byte[] array = AbstractDiskHttpData.readFrom(this.file);
            return new String(array, HttpConstants.DEFAULT_CHARSET.name());
        }
        byte[] array = AbstractDiskHttpData.readFrom(this.file);
        return new String(array, encoding.name());
    }

    public boolean isInMemory() {
        return false;
    }

    public boolean renameTo(File dest) throws IOException {
        if (dest == null) {
            throw new NullPointerException("dest");
        }
        if (!this.file.renameTo(dest)) {
            long position;
            FileInputStream inputStream = new FileInputStream(this.file);
            FileOutputStream outputStream = new FileOutputStream(dest);
            FileChannel in = inputStream.getChannel();
            FileChannel out = outputStream.getChannel();
            int chunkSize = 8196;
            for (position = 0L; position < this.size; position += in.transferTo(position, chunkSize, out)) {
                if ((long)chunkSize >= this.size - position) continue;
                chunkSize = (int)(this.size - position);
            }
            in.close();
            out.close();
            if (position == this.size) {
                this.file.delete();
                this.file = dest;
                this.isRenamed = true;
                return true;
            }
            dest.delete();
            return false;
        }
        this.file = dest;
        this.isRenamed = true;
        return true;
    }

    private static byte[] readFrom(File src) throws IOException {
        long srcsize = src.length();
        if (srcsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        FileInputStream inputStream = new FileInputStream(src);
        FileChannel fileChannel = inputStream.getChannel();
        byte[] array = new byte[(int)srcsize];
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        int read2 = 0;
        while ((long)read2 < srcsize) {
            read2 += fileChannel.read(byteBuffer);
        }
        fileChannel.close();
        return array;
    }

    public File getFile() throws IOException {
        return this.file;
    }
}

