/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.jboss.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelEvent;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelHandler;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelHandlerContext;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelState;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelStateEvent;
import org.graylog.shaded.kafka09.org.jboss.netty.handler.ipfilter.IpFilteringHandlerImpl;

@ChannelHandler.Sharable
public class OneIpFilterHandler
extends IpFilteringHandlerImpl {
    private final ConcurrentMap<InetAddress, Boolean> connectedSet = new ConcurrentHashMap<InetAddress, Boolean>();

    protected boolean accept(ChannelHandlerContext ctx, ChannelEvent e, InetSocketAddress inetSocketAddress) throws Exception {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (this.connectedSet.containsKey(inetAddress)) {
            return false;
        }
        this.connectedSet.put(inetAddress, Boolean.TRUE);
        return true;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent evt;
        super.handleUpstream(ctx, e);
        if (e instanceof ChannelStateEvent && (evt = (ChannelStateEvent)e).getState() == ChannelState.CONNECTED && evt.getValue() == null && this.isBlocked(ctx)) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)e.getChannel().getRemoteAddress();
            this.connectedSet.remove(inetSocketAddress.getAddress());
        }
    }
}

