/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.log4j.lf5.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class StreamUtils {
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static void copy(InputStream input2, OutputStream output) throws IOException {
        StreamUtils.copy(input2, output, 2048);
    }

    public static void copy(InputStream input2, OutputStream output, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        int bytesRead = input2.read(buf);
        while (bytesRead != -1) {
            output.write(buf, 0, bytesRead);
            bytesRead = input2.read(buf);
        }
        output.flush();
    }

    public static void copyThenClose(InputStream input2, OutputStream output) throws IOException {
        StreamUtils.copy(input2, output);
        input2.close();
        output.close();
    }

    public static byte[] getBytes(InputStream input2) throws IOException {
        ByteArrayOutputStream result2 = new ByteArrayOutputStream();
        StreamUtils.copy(input2, result2);
        result2.close();
        return result2.toByteArray();
    }
}

