/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import org.graylog.shaded.kafka09.javax.swing.JCheckBox;
import org.graylog.shaded.kafka09.javax.swing.JMenuItem;
import org.graylog.shaded.kafka09.javax.swing.JOptionPane;
import org.graylog.shaded.kafka09.javax.swing.JPopupMenu;
import org.graylog.shaded.kafka09.javax.swing.JTree;
import org.graylog.shaded.kafka09.javax.swing.tree.MutableTreeNode;
import org.graylog.shaded.kafka09.javax.swing.tree.TreePath;
import org.graylog.shaded.kafka09.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryAbstractCellEditor;
import org.graylog.shaded.kafka09.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerModel;
import org.graylog.shaded.kafka09.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.graylog.shaded.kafka09.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNodeEditorRenderer;

public class CategoryNodeEditor
extends CategoryAbstractCellEditor {
    protected CategoryNodeEditorRenderer _renderer = new CategoryNodeEditorRenderer();
    protected CategoryNode _lastEditedNode;
    protected JCheckBox _checkBox = this._renderer.getCheckBox();
    protected CategoryExplorerModel _categoryModel;
    protected JTree _tree;

    public CategoryNodeEditor(CategoryExplorerModel model) {
        this._categoryModel = model;
        this._checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryNodeEditor.this._categoryModel.update(CategoryNodeEditor.this._lastEditedNode, CategoryNodeEditor.this._checkBox.isSelected());
                CategoryNodeEditor.this.stopCellEditing();
            }
        });
        ((Component)((Object)this._renderer)).addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    CategoryNodeEditor.this.showPopup(CategoryNodeEditor.this._lastEditedNode, e.getX(), e.getY());
                }
                CategoryNodeEditor.this.stopCellEditing();
            }
        });
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row) {
        this._lastEditedNode = (CategoryNode)((Object)value2);
        this._tree = tree;
        return this._renderer.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, true);
    }

    public Object getCellEditorValue() {
        return this._lastEditedNode.getUserObject();
    }

    protected JMenuItem createPropertiesMenuItem(final CategoryNode node) {
        JMenuItem result2 = new JMenuItem("Properties");
        result2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryNodeEditor.this.showPropertiesDialog(node);
            }
        });
        return result2;
    }

    protected void showPropertiesDialog(CategoryNode node) {
        JOptionPane.showMessageDialog((Component)this._tree, (Object)this.getDisplayedProperties(node), (String)("Category Properties: " + node.getTitle()), (int)-1);
    }

    protected Object getDisplayedProperties(CategoryNode node) {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add("Category: " + node.getTitle());
        if (node.hasFatalRecords()) {
            result2.add("Contains at least one fatal LogRecord.");
        }
        if (node.hasFatalChildren()) {
            result2.add("Contains descendants with a fatal LogRecord.");
        }
        result2.add("LogRecords in this category alone: " + node.getNumberOfContainedRecords());
        result2.add("LogRecords in descendant categories: " + node.getNumberOfRecordsFromChildren());
        result2.add("LogRecords in this category including descendants: " + node.getTotalNumberOfRecords());
        return result2.toArray();
    }

    protected void showPopup(CategoryNode node, int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        popup.setSize(150, 400);
        if (node.getParent() == null) {
            popup.add(this.createRemoveMenuItem());
            popup.addSeparator();
        }
        popup.add(this.createSelectDescendantsMenuItem(node));
        popup.add(this.createUnselectDescendantsMenuItem(node));
        popup.addSeparator();
        popup.add(this.createExpandMenuItem(node));
        popup.add(this.createCollapseMenuItem(node));
        popup.addSeparator();
        popup.add(this.createPropertiesMenuItem(node));
        popup.show((Component)((Object)this._renderer), x, y);
    }

    protected JMenuItem createSelectDescendantsMenuItem(final CategoryNode node) {
        JMenuItem selectDescendants = new JMenuItem("Select All Descendant Categories");
        selectDescendants.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryNodeEditor.this._categoryModel.setDescendantSelection(node, true);
            }
        });
        return selectDescendants;
    }

    protected JMenuItem createUnselectDescendantsMenuItem(final CategoryNode node) {
        JMenuItem unselectDescendants = new JMenuItem("Deselect All Descendant Categories");
        unselectDescendants.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryNodeEditor.this._categoryModel.setDescendantSelection(node, false);
            }
        });
        return unselectDescendants;
    }

    protected JMenuItem createExpandMenuItem(final CategoryNode node) {
        JMenuItem result2 = new JMenuItem("Expand All Descendant Categories");
        result2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryNodeEditor.this.expandDescendants(node);
            }
        });
        return result2;
    }

    protected JMenuItem createCollapseMenuItem(final CategoryNode node) {
        JMenuItem result2 = new JMenuItem("Collapse All Descendant Categories");
        result2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CategoryNodeEditor.this.collapseDescendants(node);
            }
        });
        return result2;
    }

    protected JMenuItem createRemoveMenuItem() {
        JMenuItem result2 = new JMenuItem("Remove All Empty Categories");
        result2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                while (CategoryNodeEditor.this.removeUnusedNodes() > 0) {
                }
            }
        });
        return result2;
    }

    protected void expandDescendants(CategoryNode node) {
        Enumeration descendants = node.depthFirstEnumeration();
        while (descendants.hasMoreElements()) {
            CategoryNode current = (CategoryNode)((Object)descendants.nextElement());
            this.expand(current);
        }
    }

    protected void collapseDescendants(CategoryNode node) {
        Enumeration descendants = node.depthFirstEnumeration();
        while (descendants.hasMoreElements()) {
            CategoryNode current = (CategoryNode)((Object)descendants.nextElement());
            this.collapse(current);
        }
    }

    protected int removeUnusedNodes() {
        int count2 = 0;
        CategoryNode root2 = this._categoryModel.getRootCategoryNode();
        Enumeration enumeration = root2.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode node = (CategoryNode)((Object)enumeration.nextElement());
            if (!node.isLeaf() || node.getNumberOfContainedRecords() != 0 || node.getParent() == null) continue;
            this._categoryModel.removeNodeFromParent((MutableTreeNode)node);
            ++count2;
        }
        return count2;
    }

    protected void expand(CategoryNode node) {
        this._tree.expandPath(this.getTreePath(node));
    }

    protected TreePath getTreePath(CategoryNode node) {
        return new TreePath((Object[])node.getPath());
    }

    protected void collapse(CategoryNode node) {
        this._tree.collapsePath(this.getTreePath(node));
    }
}

