/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.log4j.spi;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.graylog.shaded.kafka09.org.apache.log4j.Layout;
import org.graylog.shaded.kafka09.org.apache.log4j.helpers.LogLog;

public class LocationInfo
implements Serializable {
    transient String lineNumber;
    transient String fileName;
    transient String className;
    transient String methodName;
    public String fullInfo;
    private static StringWriter sw = new StringWriter();
    private static PrintWriter pw = new PrintWriter(sw);
    public static final String NA = "?";
    static final long serialVersionUID = -1325822038990805636L;
    public static final LocationInfo NA_LOCATION_INFO = new LocationInfo("?", "?", "?", "?");
    static boolean inVisualAge = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationInfo(Throwable t, String fqnOfCallingClass) {
        String s2;
        if (t == null || fqnOfCallingClass == null) {
            return;
        }
        StringWriter stringWriter = sw;
        synchronized (stringWriter) {
            t.printStackTrace(pw);
            s2 = sw.toString();
            sw.getBuffer().setLength(0);
        }
        int ibegin = s2.lastIndexOf(fqnOfCallingClass);
        if (ibegin == -1) {
            return;
        }
        if ((ibegin = s2.indexOf(Layout.LINE_SEP, ibegin)) == -1) {
            return;
        }
        int iend = s2.indexOf(Layout.LINE_SEP, ibegin += Layout.LINE_SEP_LEN);
        if (iend == -1) {
            return;
        }
        if (!inVisualAge) {
            ibegin = s2.lastIndexOf("at ", iend);
            if (ibegin == -1) {
                return;
            }
            ibegin += 3;
        }
        this.fullInfo = s2.substring(ibegin, iend);
    }

    private static final void appendFragment(StringBuffer buf, String fragment) {
        if (fragment == null) {
            buf.append(NA);
        } else {
            buf.append(fragment);
        }
    }

    public LocationInfo(String file, String classname, String method, String line) {
        this.fileName = file;
        this.className = classname;
        this.methodName = method;
        this.lineNumber = line;
        StringBuffer buf = new StringBuffer();
        LocationInfo.appendFragment(buf, classname);
        buf.append(".");
        LocationInfo.appendFragment(buf, method);
        buf.append("(");
        LocationInfo.appendFragment(buf, file);
        buf.append(":");
        LocationInfo.appendFragment(buf, line);
        buf.append(")");
        this.fullInfo = buf.toString();
    }

    public String getClassName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.className == null) {
            int iend = this.fullInfo.lastIndexOf(40);
            if (iend == -1) {
                this.className = NA;
            } else {
                iend = this.fullInfo.lastIndexOf(46, iend);
                int ibegin = 0;
                if (inVisualAge) {
                    ibegin = this.fullInfo.lastIndexOf(32, iend) + 1;
                }
                this.className = iend == -1 ? NA : this.fullInfo.substring(ibegin, iend);
            }
        }
        return this.className;
    }

    public String getFileName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.fileName == null) {
            int iend = this.fullInfo.lastIndexOf(58);
            if (iend == -1) {
                this.fileName = NA;
            } else {
                int ibegin = this.fullInfo.lastIndexOf(40, iend - 1);
                this.fileName = this.fullInfo.substring(ibegin + 1, iend);
            }
        }
        return this.fileName;
    }

    public String getLineNumber() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.lineNumber == null) {
            int iend = this.fullInfo.lastIndexOf(41);
            int ibegin = this.fullInfo.lastIndexOf(58, iend - 1);
            this.lineNumber = ibegin == -1 ? NA : this.fullInfo.substring(ibegin + 1, iend);
        }
        return this.lineNumber;
    }

    public String getMethodName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.methodName == null) {
            int iend = this.fullInfo.lastIndexOf(40);
            int ibegin = this.fullInfo.lastIndexOf(46, iend);
            this.methodName = ibegin == -1 ? NA : this.fullInfo.substring(ibegin + 1, iend);
        }
        return this.methodName;
    }

    static {
        try {
            inVisualAge = Class.forName("com.ibm.uvm.tools.DebugSupport") != null;
            LogLog.debug("Detected IBM VisualAge environment.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

