/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.zookeeper.server.util;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.kafka09.org.apache.jute.BinaryInputArchive;
import org.graylog.shaded.kafka09.org.apache.jute.InputArchive;
import org.graylog.shaded.kafka09.org.apache.jute.OutputArchive;
import org.graylog.shaded.kafka09.org.apache.jute.Record;
import org.graylog.shaded.kafka09.org.apache.zookeeper.server.DataTree;
import org.graylog.shaded.kafka09.org.apache.zookeeper.server.ZooTrace;
import org.graylog.shaded.kafka09.org.apache.zookeeper.txn.CreateSessionTxn;
import org.graylog.shaded.kafka09.org.apache.zookeeper.txn.CreateTxn;
import org.graylog.shaded.kafka09.org.apache.zookeeper.txn.CreateTxnV0;
import org.graylog.shaded.kafka09.org.apache.zookeeper.txn.DeleteTxn;
import org.graylog.shaded.kafka09.org.apache.zookeeper.txn.ErrorTxn;
import org.graylog.shaded.kafka09.org.apache.zookeeper.txn.MultiTxn;
import org.graylog.shaded.kafka09.org.apache.zookeeper.txn.SetACLTxn;
import org.graylog.shaded.kafka09.org.apache.zookeeper.txn.SetDataTxn;
import org.graylog.shaded.kafka09.org.apache.zookeeper.txn.TxnHeader;
import org.graylog.shaded.kafka09.org.slf4j.Logger;
import org.graylog.shaded.kafka09.org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializeUtils.class);

    public static Record deserializeTxn(byte[] txnBytes, TxnHeader hdr) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(txnBytes);
        BinaryInputArchive ia = BinaryInputArchive.getArchive(bais);
        hdr.deserialize(ia, "hdr");
        bais.mark(bais.available());
        Record txn = null;
        switch (hdr.getType()) {
            case -10: {
                txn = new CreateSessionTxn();
                break;
            }
            case -11: {
                return null;
            }
            case 1: {
                txn = new CreateTxn();
                break;
            }
            case 2: {
                txn = new DeleteTxn();
                break;
            }
            case 5: {
                txn = new SetDataTxn();
                break;
            }
            case 7: {
                txn = new SetACLTxn();
                break;
            }
            case -1: {
                txn = new ErrorTxn();
                break;
            }
            case 14: {
                txn = new MultiTxn();
                break;
            }
            default: {
                throw new IOException("Unsupported Txn with type=%d" + hdr.getType());
            }
        }
        if (txn != null) {
            try {
                txn.deserialize(ia, "txn");
            }
            catch (EOFException e) {
                if (hdr.getType() == 1) {
                    CreateTxn create2 = (CreateTxn)txn;
                    bais.reset();
                    CreateTxnV0 createv0 = new CreateTxnV0();
                    createv0.deserialize(ia, "txn");
                    create2.setPath(createv0.getPath());
                    create2.setData(createv0.getData());
                    create2.setAcl(createv0.getAcl());
                    create2.setEphemeral(createv0.getEphemeral());
                    create2.setParentCVersion(-1);
                }
                throw e;
            }
        }
        return txn;
    }

    public static void deserializeSnapshot(DataTree dt, InputArchive ia, Map<Long, Integer> sessions) throws IOException {
        for (int count2 = ia.readInt("count"); count2 > 0; --count2) {
            long id = ia.readLong("id");
            int to2 = ia.readInt("timeout");
            sessions.put(id, to2);
            if (!LOG.isTraceEnabled()) continue;
            ZooTrace.logTraceMessage(LOG, 32L, "loadData --- session in archive: " + id + " with timeout: " + to2);
        }
        dt.deserialize(ia, "tree");
    }

    public static void serializeSnapshot(DataTree dt, OutputArchive oa, Map<Long, Integer> sessions) throws IOException {
        HashMap<Long, Integer> sessSnap = new HashMap<Long, Integer>(sessions);
        oa.writeInt(sessSnap.size(), "count");
        for (Map.Entry<Long, Integer> entry2 : sessSnap.entrySet()) {
            oa.writeLong(entry2.getKey(), "id");
            oa.writeInt(entry2.getValue(), "timeout");
        }
        dt.serialize(oa, "tree");
    }
}

