/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.jline;

import java.io.IOException;
import java.io.InputStream;
import org.graylog.shaded.kafka09.jline.ConsoleOperations;
import org.graylog.shaded.kafka09.jline.ConsoleReader;
import org.graylog.shaded.kafka09.jline.UnixTerminal;
import org.graylog.shaded.kafka09.jline.UnsupportedTerminal;
import org.graylog.shaded.kafka09.jline.WindowsTerminal;

public abstract class Terminal
implements ConsoleOperations {
    private static Terminal term;
    static /* synthetic */ Class class$jline$Terminal;

    public static Terminal getTerminal() {
        return Terminal.setupTerminal();
    }

    public static void resetTerminal() {
        term = null;
    }

    public static synchronized Terminal setupTerminal() {
        Terminal t;
        if (term != null) {
            return term;
        }
        String os = System.getProperty("os.name").toLowerCase();
        String termProp = System.getProperty("org.graylog.shaded.kafka09.jline.terminal");
        if (termProp != null && termProp.length() > 0) {
            try {
                t = (Terminal)Class.forName(termProp).newInstance();
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException(e.toString()).fillInStackTrace();
            }
        } else {
            t = os.indexOf("windows") != -1 ? new WindowsTerminal() : new UnixTerminal();
        }
        try {
            t.initializeTerminal();
        }
        catch (Exception e) {
            e.printStackTrace();
            term = new UnsupportedTerminal();
            return term;
        }
        term = t;
        return term;
    }

    public boolean isANSISupported() {
        return true;
    }

    public int readCharacter(InputStream in) throws IOException {
        return in.read();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        return this.readCharacter(in);
    }

    public abstract void initializeTerminal() throws Exception;

    public abstract int getTerminalWidth();

    public abstract int getTerminalHeight();

    public abstract boolean isSupported();

    public abstract boolean getEcho();

    public void beforeReadLine(ConsoleReader reader, String prompt, Character mask) {
    }

    public void afterReadLine(ConsoleReader reader, String prompt, Character mask) {
    }

    public abstract boolean isEchoEnabled();

    public abstract void enableEcho();

    public abstract void disableEcho();

    public InputStream getDefaultBindings() {
        return (class$jline$Terminal == null ? (class$jline$Terminal = Terminal.class$("org.graylog.shaded.kafka09.jline.Terminal")) : class$jline$Terminal).getResourceAsStream("keybindings.properties");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

