/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.kafka.clients;

import org.graylog.shaded.kafka09.org.apache.kafka.clients.ClientRequest;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Struct;

public class ClientResponse {
    private final long receivedTimeMs;
    private final boolean disconnected;
    private final ClientRequest request;
    private final Struct responseBody;

    public ClientResponse(ClientRequest request, long receivedTimeMs, boolean disconnected, Struct responseBody) {
        this.receivedTimeMs = receivedTimeMs;
        this.disconnected = disconnected;
        this.request = request;
        this.responseBody = responseBody;
    }

    public long receivedTimeMs() {
        return this.receivedTimeMs;
    }

    public boolean wasDisconnected() {
        return this.disconnected;
    }

    public ClientRequest request() {
        return this.request;
    }

    public Struct responseBody() {
        return this.responseBody;
    }

    public boolean hasResponse() {
        return this.responseBody != null;
    }

    public long requestLatencyMs() {
        return this.receivedTimeMs() - this.request.createdTimeMs();
    }

    public String toString() {
        return "ClientResponse(receivedTimeMs=" + this.receivedTimeMs + ", disconnected=" + this.disconnected + ", request=" + this.request + ", responseBody=" + this.responseBody + ")";
    }
}

