/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.kafka.clients;

import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.kafka09.org.apache.kafka.clients.ConnectionState;

final class ClusterConnectionStates {
    private final long reconnectBackoffMs;
    private final Map<String, NodeConnectionState> nodeState;

    public ClusterConnectionStates(long reconnectBackoffMs) {
        this.reconnectBackoffMs = reconnectBackoffMs;
        this.nodeState = new HashMap<String, NodeConnectionState>();
    }

    public boolean canConnect(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return true;
        }
        return state.state == ConnectionState.DISCONNECTED && now - state.lastConnectAttemptMs >= this.reconnectBackoffMs;
    }

    public boolean isBlackedOut(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return false;
        }
        return state.state == ConnectionState.DISCONNECTED && now - state.lastConnectAttemptMs < this.reconnectBackoffMs;
    }

    public long connectionDelay(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return 0L;
        }
        long timeWaited = now - state.lastConnectAttemptMs;
        if (state.state == ConnectionState.DISCONNECTED) {
            return Math.max(this.reconnectBackoffMs - timeWaited, 0L);
        }
        return Long.MAX_VALUE;
    }

    public void connecting(String id, long now) {
        this.nodeState.put(id, new NodeConnectionState(ConnectionState.CONNECTING, now));
    }

    public boolean isConnected(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state == ConnectionState.CONNECTED;
    }

    public boolean isConnecting(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state == ConnectionState.CONNECTING;
    }

    public void connected(String id) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.CONNECTED;
    }

    public void disconnected(String id, long now) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.DISCONNECTED;
        nodeState.lastConnectAttemptMs = now;
    }

    public void remove(String id) {
        this.nodeState.remove(id);
    }

    public ConnectionState connectionState(String id) {
        return this.nodeState((String)id).state;
    }

    private NodeConnectionState nodeState(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            throw new IllegalStateException("No entry found for connection " + id);
        }
        return state;
    }

    private static class NodeConnectionState {
        ConnectionState state;
        long lastConnectAttemptMs;

        public NodeConnectionState(ConnectionState state, long lastConnectAttempt) {
            this.state = state;
            this.lastConnectAttemptMs = lastConnectAttempt;
        }

        public String toString() {
            return "NodeState(" + (Object)((Object)this.state) + ", " + this.lastConnectAttemptMs + ")";
        }
    }
}

