/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.kafka.clients.consumer.internals;

import java.util.Iterator;
import java.util.PriorityQueue;
import org.graylog.shaded.kafka09.org.apache.kafka.clients.consumer.internals.DelayedTask;

public class DelayedTaskQueue {
    private PriorityQueue<Entry> tasks = new PriorityQueue();

    public void add(DelayedTask task, long at) {
        this.tasks.add(new Entry(task, at));
    }

    public boolean remove(DelayedTask task) {
        boolean wasRemoved = false;
        Iterator<Entry> iterator2 = this.tasks.iterator();
        while (iterator2.hasNext()) {
            Entry entry2 = iterator2.next();
            if (!entry2.task.equals(task)) continue;
            iterator2.remove();
            wasRemoved = true;
        }
        return wasRemoved;
    }

    public long nextTimeout(long now) {
        if (this.tasks.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return Math.max(this.tasks.peek().timeout - now, 0L);
    }

    public void poll(long now) {
        while (!this.tasks.isEmpty() && this.tasks.peek().timeout <= now) {
            Entry entry2 = this.tasks.poll();
            entry2.task.run(now);
        }
    }

    private static class Entry
    implements Comparable<Entry> {
        DelayedTask task;
        long timeout;

        public Entry(DelayedTask task, long timeout) {
            this.task = task;
            this.timeout = timeout;
        }

        @Override
        public int compareTo(Entry entry2) {
            return Long.compare(this.timeout, entry2.timeout);
        }
    }
}

