/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.graylog.shaded.kafka09.org.apache.kafka.common.network.NetworkSend;
import org.graylog.shaded.kafka09.org.apache.kafka.common.protocol.types.Struct;
import org.graylog.shaded.kafka09.org.apache.kafka.common.requests.RequestHeader;

public class RequestSend
extends NetworkSend {
    private final RequestHeader header;
    private final Struct body;

    public RequestSend(String destination, RequestHeader header, Struct body) {
        super(destination, RequestSend.serialize(header, body));
        this.header = header;
        this.body = body;
    }

    private static ByteBuffer serialize(RequestHeader header, Struct body) {
        ByteBuffer buffer = ByteBuffer.allocate(header.sizeOf() + body.sizeOf());
        header.writeTo(buffer);
        body.writeTo(buffer);
        buffer.rewind();
        return buffer;
    }

    public RequestHeader header() {
        return this.header;
    }

    public Struct body() {
        return this.body;
    }

    public String toString() {
        return "RequestSend(header=" + this.header.toString() + ", body=" + this.body.toString() + ")";
    }
}

