/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.apache.zookeeper.server;

import org.graylog.shaded.kafka09.org.apache.zookeeper.server.Request;
import org.graylog.shaded.kafka09.org.apache.zookeeper.server.quorum.QuorumPacket;
import org.graylog.shaded.kafka09.org.slf4j.Logger;
import org.graylog.shaded.kafka09.org.slf4j.LoggerFactory;

public class ZooTrace {
    public static final long CLIENT_REQUEST_TRACE_MASK = 2L;
    public static final long CLIENT_DATA_PACKET_TRACE_MASK = 4L;
    public static final long CLIENT_PING_TRACE_MASK = 8L;
    public static final long SERVER_PACKET_TRACE_MASK = 16L;
    public static final long SESSION_TRACE_MASK = 32L;
    public static final long EVENT_DELIVERY_TRACE_MASK = 64L;
    public static final long SERVER_PING_TRACE_MASK = 128L;
    public static final long WARNING_TRACE_MASK = 256L;
    public static final long JMX_TRACE_MASK = 512L;
    private static long traceMask = 306L;

    public static long getTextTraceLevel() {
        return traceMask;
    }

    public static void setTextTraceLevel(long mask) {
        traceMask = mask;
        Logger LOG = LoggerFactory.getLogger(ZooTrace.class);
        LOG.info("Set text trace mask to 0x" + Long.toHexString(mask));
    }

    public static boolean isTraceEnabled(Logger log2, long mask) {
        return log2.isTraceEnabled() && (mask & traceMask) != 0L;
    }

    public static void logTraceMessage(Logger log2, long mask, String msg) {
        if (ZooTrace.isTraceEnabled(log2, mask)) {
            log2.trace(msg);
        }
    }

    public static void logQuorumPacket(Logger log2, long mask, char direction, QuorumPacket qp) {
    }

    public static void logRequest(Logger log2, long mask, char rp, Request request, String header) {
        if (ZooTrace.isTraceEnabled(log2, mask)) {
            log2.trace(header + ":" + rp + request.toString());
        }
    }
}

