/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.oio;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelPipeline;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.ChannelSink;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.ServerSocketChannel;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.oio.OioServerSocketChannel;
import org.graylog.shaded.kafka09.org.jboss.netty.channel.socket.oio.OioServerSocketPipelineSink;
import org.graylog.shaded.kafka09.org.jboss.netty.util.ThreadNameDeterminer;
import org.graylog.shaded.kafka09.org.jboss.netty.util.internal.ExecutorUtil;

public class OioServerSocketChannelFactory
implements ServerSocketChannelFactory {
    final Executor bossExecutor;
    private final Executor workerExecutor;
    private final ChannelSink sink;
    private boolean shutdownExecutor;

    public OioServerSocketChannelFactory() {
        this(Executors.newCachedThreadPool(), Executors.newCachedThreadPool());
        this.shutdownExecutor = true;
    }

    public OioServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        this(bossExecutor, workerExecutor, null);
    }

    public OioServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, ThreadNameDeterminer determiner) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.bossExecutor = bossExecutor;
        this.workerExecutor = workerExecutor;
        this.sink = new OioServerSocketPipelineSink(workerExecutor, determiner);
    }

    public ServerSocketChannel newChannel(ChannelPipeline pipeline) {
        return new OioServerSocketChannel(this, pipeline, this.sink);
    }

    public void shutdown() {
        if (this.shutdownExecutor) {
            ExecutorUtil.shutdownNow(this.workerExecutor);
        }
    }

    public void releaseExternalResources() {
        this.shutdown();
        ExecutorUtil.shutdownNow(this.workerExecutor);
    }
}

