/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.cluster;

import java.nio.ByteBuffer;
import org.graylog.shaded.kafka09.cluster.Broker;
import org.graylog.shaded.kafka09.cluster.EndPoint;
import org.graylog.shaded.kafka09.cluster.EndPoint$;
import org.graylog.shaded.kafka09.common.BrokerNotAvailableException;
import org.graylog.shaded.kafka09.common.KafkaException;
import org.graylog.shaded.kafka09.scala.MatchError;
import org.graylog.shaded.kafka09.scala.None$;
import org.graylog.shaded.kafka09.scala.Option;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Predef$ArrowAssoc$;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.Some;
import org.graylog.shaded.kafka09.scala.StringContext;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.TraversableOnce;
import org.graylog.shaded.kafka09.scala.collection.immutable.List;
import org.graylog.shaded.kafka09.scala.collection.immutable.List$;
import org.graylog.shaded.kafka09.scala.collection.immutable.Map;
import org.graylog.shaded.kafka09.scala.math.Numeric$IntIsIntegral$;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.utils.Json$;
import org.graylog.shaded.org.apache.kafka09.common.protocol.SecurityProtocol;

public final class Broker$
implements Serializable {
    public static final Broker$ MODULE$;

    static {
        new Broker$();
    }

    public Broker createBroker(int id, String brokerInfoString) {
        if (brokerInfoString == null) {
            throw new BrokerNotAvailableException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
        }
        try {
            Option<Object> option = Json$.MODULE$.parseFull(brokerInfoString);
            if (option instanceof Some) {
                Map map2;
                Some some = (Some)option;
                Object m = some.x();
                Map brokerInfo = (Map)m;
                int version = BoxesRunTime.unboxToInt(brokerInfo.apply("version"));
                if (version < 1) {
                    throw new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported version of broker registration: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{brokerInfoString})));
                }
                if (version == 1) {
                    String host = (String)brokerInfo.apply("host");
                    int port = BoxesRunTime.unboxToInt(brokerInfo.apply("port"));
                    map2 = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(SecurityProtocol.PLAINTEXT), new EndPoint(host, port, SecurityProtocol.PLAINTEXT))}));
                } else {
                    List listeners = (List)brokerInfo.apply("endpoints");
                    map2 = ((TraversableOnce)listeners.map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<SecurityProtocol, EndPoint> apply(String listener) {
                            EndPoint ep = EndPoint$.MODULE$.createEndPoint(listener);
                            return new Tuple2<SecurityProtocol, EndPoint>(ep.protocolType(), ep);
                        }
                    }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                }
                Map endpoints = map2;
                Broker broker = new Broker(id, endpoints);
                return broker;
            }
            if (None$.MODULE$.equals(option)) {
                throw new BrokerNotAvailableException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
            }
            throw new MatchError(option);
        }
        catch (Throwable throwable) {
            throw new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse the broker info from zookeeper: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{brokerInfoString})), throwable);
        }
    }

    public Broker readFrom(ByteBuffer buffer) {
        int id = buffer.getInt();
        int numEndpoints = buffer.getInt();
        Map<SecurityProtocol, EndPoint> endpoints = ((TraversableOnce)((List)List$.MODULE$.range(BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(numEndpoints), Numeric$IntIsIntegral$.MODULE$)).map(new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;

            public final EndPoint apply(int i) {
                return EndPoint$.MODULE$.readFrom(this.buffer$1);
            }
            {
                this.buffer$1 = buffer$1;
            }
        }, List$.MODULE$.canBuildFrom()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<SecurityProtocol, EndPoint> apply(EndPoint ep) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ep.protocolType()), ep);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new Broker(id, endpoints);
    }

    public Broker apply(int id, Map<SecurityProtocol, EndPoint> endPoints) {
        return new Broker(id, endPoints);
    }

    public Option<Tuple2<Object, Map<SecurityProtocol, EndPoint>>> unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<Integer, Map<SecurityProtocol, EndPoint>>>(new Tuple2<Integer, Map<SecurityProtocol, EndPoint>>(BoxesRunTime.boxToInteger(x$0.id()), x$0.endPoints()));
    }

    public SecurityProtocol $lessinit$greater$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
    }
}

