/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.joptsimple.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.graylog.shaded.kafka09.joptsimple.internal.Column;
import org.graylog.shaded.kafka09.joptsimple.internal.ColumnWidthCalculator;

public class ColumnarData {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int TOTAL_WIDTH = 80;
    private final ColumnWidthCalculator widthCalculator;
    private final List<Column> columns;
    private final String[] headers;

    public ColumnarData(String ... headers) {
        this.headers = (String[])headers.clone();
        this.widthCalculator = new ColumnWidthCalculator();
        this.columns = new LinkedList<Column>();
        this.clear();
    }

    public void addRow(Object ... rowData) {
        int[] numberOfCellsAddedAt = this.addRowCells(rowData);
        this.addPaddingCells(numberOfCellsAddedAt);
    }

    public String format() {
        StringBuilder buffer = new StringBuilder();
        this.writeHeadersOn(buffer);
        this.writeSeparatorsOn(buffer);
        this.writeRowsOn(buffer);
        return buffer.toString();
    }

    public final void clear() {
        this.columns.clear();
        int desiredColumnWidth = this.widthCalculator.calculate(80, this.headers.length);
        for (String each : this.headers) {
            this.columns.add(new Column(each, desiredColumnWidth));
        }
    }

    private void writeHeadersOn(StringBuilder buffer) {
        Iterator<Column> iter2 = this.columns.iterator();
        while (iter2.hasNext()) {
            iter2.next().writeHeaderOn(buffer, iter2.hasNext());
        }
        buffer.append(LINE_SEPARATOR);
    }

    private void writeSeparatorsOn(StringBuilder buffer) {
        Iterator<Column> iter2 = this.columns.iterator();
        while (iter2.hasNext()) {
            iter2.next().writeSeparatorOn(buffer, iter2.hasNext());
        }
        buffer.append(LINE_SEPARATOR);
    }

    private void writeRowsOn(StringBuilder buffer) {
        int maxHeight = Collections.max(this.columns, Column.BY_HEIGHT).height();
        for (int i = 0; i < maxHeight; ++i) {
            this.writeRowOn(buffer, i);
        }
    }

    private void writeRowOn(StringBuilder buffer, int rowIndex) {
        Iterator<Column> iter2 = this.columns.iterator();
        while (iter2.hasNext()) {
            iter2.next().writeCellOn(rowIndex, buffer, iter2.hasNext());
        }
        buffer.append(LINE_SEPARATOR);
    }

    private int arrayMax(int[] numbers) {
        int maximum = Integer.MIN_VALUE;
        for (int each : numbers) {
            maximum = Math.max(maximum, each);
        }
        return maximum;
    }

    private int[] addRowCells(Object ... rowData) {
        int[] cellsAddedAt = new int[rowData.length];
        Iterator<Column> iter2 = this.columns.iterator();
        for (int i = 0; iter2.hasNext() && i < rowData.length; ++i) {
            cellsAddedAt[i] = iter2.next().addCells(rowData[i]);
        }
        return cellsAddedAt;
    }

    private void addPaddingCells(int ... numberOfCellsAddedAt) {
        int maxHeight = this.arrayMax(numberOfCellsAddedAt);
        Iterator<Column> iter2 = this.columns.iterator();
        for (int i = 0; iter2.hasNext() && i < numberOfCellsAddedAt.length; ++i) {
            this.addPaddingCellsForColumn(iter2.next(), maxHeight, numberOfCellsAddedAt[i]);
        }
    }

    private void addPaddingCellsForColumn(Column column, int maxHeight, int numberOfCellsAdded) {
        for (int i = 0; i < maxHeight - numberOfCellsAdded; ++i) {
            column.addCell("");
        }
    }
}

