/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.network;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.org.apache.kafka09.common.KafkaException;
import org.graylog.shaded.org.apache.kafka09.common.network.Authenticator;
import org.graylog.shaded.org.apache.kafka09.common.network.ChannelBuilder;
import org.graylog.shaded.org.apache.kafka09.common.network.KafkaChannel;
import org.graylog.shaded.org.apache.kafka09.common.network.LoginType;
import org.graylog.shaded.org.apache.kafka09.common.network.Mode;
import org.graylog.shaded.org.apache.kafka09.common.network.PlaintextTransportLayer;
import org.graylog.shaded.org.apache.kafka09.common.network.SslTransportLayer;
import org.graylog.shaded.org.apache.kafka09.common.network.TransportLayer;
import org.graylog.shaded.org.apache.kafka09.common.protocol.SecurityProtocol;
import org.graylog.shaded.org.apache.kafka09.common.security.JaasUtils;
import org.graylog.shaded.org.apache.kafka09.common.security.authenticator.SaslClientAuthenticator;
import org.graylog.shaded.org.apache.kafka09.common.security.authenticator.SaslServerAuthenticator;
import org.graylog.shaded.org.apache.kafka09.common.security.kerberos.KerberosShortNamer;
import org.graylog.shaded.org.apache.kafka09.common.security.kerberos.LoginManager;
import org.graylog.shaded.org.apache.kafka09.common.security.ssl.SslFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(SaslChannelBuilder.class);
    private final SecurityProtocol securityProtocol;
    private final Mode mode;
    private final LoginType loginType;
    private LoginManager loginManager;
    private SslFactory sslFactory;
    private Map<String, ?> configs;
    private KerberosShortNamer kerberosShortNamer;

    public SaslChannelBuilder(Mode mode, LoginType loginType, SecurityProtocol securityProtocol) {
        this.mode = mode;
        this.loginType = loginType;
        this.securityProtocol = securityProtocol;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            String defaultRealm;
            this.configs = configs;
            this.loginManager = LoginManager.acquireLoginManager(this.loginType, configs);
            try {
                defaultRealm = JaasUtils.defaultRealm();
            }
            catch (Exception ke) {
                defaultRealm = "";
            }
            List principalToLocalRules = (List)configs.get("sasl.kerberos.principal.to.local.rules");
            if (principalToLocalRules != null) {
                this.kerberosShortNamer = KerberosShortNamer.fromUnparsedRules(defaultRealm, principalToLocalRules);
            }
            if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
                this.sslFactory = new SslFactory(this.mode, "none");
                this.sslFactory.configure(configs);
            }
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize) throws KafkaException {
        try {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            TransportLayer transportLayer = this.buildTransportLayer(id, key, socketChannel);
            Authenticator authenticator = this.mode == Mode.SERVER ? new SaslServerAuthenticator(id, this.loginManager.subject(), this.kerberosShortNamer, maxReceiveSize) : new SaslClientAuthenticator(id, this.loginManager.subject(), this.loginManager.serviceName(), socketChannel.socket().getInetAddress().getHostName());
            authenticator.configure(transportLayer, null, this.configs);
            return new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize);
        }
        catch (Exception e) {
            log.info("Failed to create channel due to ", (Throwable)e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        this.loginManager.release();
    }

    protected TransportLayer buildTransportLayer(String id, SelectionKey key, SocketChannel socketChannel) throws IOException {
        if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
            return SslTransportLayer.create(id, key, this.sslFactory.createSslEngine(socketChannel.socket().getInetAddress().getHostName(), socketChannel.socket().getPort()));
        }
        return new PlaintextTransportLayer(key);
    }
}

