/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.security.kerberos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.graylog.shaded.org.apache.kafka09.common.network.LoginType;
import org.graylog.shaded.org.apache.kafka09.common.security.JaasUtils;
import org.graylog.shaded.org.apache.kafka09.common.security.kerberos.Login;

public class LoginManager {
    private static final EnumMap<LoginType, LoginManager> CACHED_INSTANCES = new EnumMap(LoginType.class);
    private final Login login;
    private final String serviceName;
    private final LoginType loginType;
    private int refCount;

    private LoginManager(LoginType loginType, Map<String, ?> configs) throws IOException, LoginException {
        this.loginType = loginType;
        String loginContext = loginType.contextName();
        this.login = new Login(loginContext, configs);
        this.serviceName = LoginManager.getServiceName(loginContext, configs);
        this.login.startThreadIfNeeded();
    }

    private static String getServiceName(String loginContext, Map<String, ?> configs) throws IOException {
        String jaasServiceName = JaasUtils.jaasConfig(loginContext, "serviceName");
        String configServiceName = (String)configs.get("sasl.kerberos.service.name");
        if (jaasServiceName != null && configServiceName != null && !jaasServiceName.equals(configServiceName)) {
            String message = "Conflicting serviceName values found in JAAS and Kafka configs value in JAAS file " + jaasServiceName + ", value in Kafka config " + configServiceName;
            throw new IllegalArgumentException(message);
        }
        if (jaasServiceName != null) {
            return jaasServiceName;
        }
        if (configServiceName != null) {
            return configServiceName;
        }
        throw new IllegalArgumentException("No serviceName defined in either JAAS or Kafka config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LoginManager acquireLoginManager(LoginType loginType, Map<String, ?> configs) throws IOException, LoginException {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            LoginManager loginManager = CACHED_INSTANCES.get((Object)loginType);
            if (loginManager == null) {
                loginManager = new LoginManager(loginType, configs);
                CACHED_INSTANCES.put(loginType, loginManager);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return loginManager.acquire();
        }
    }

    public Subject subject() {
        return this.login.subject();
    }

    public String serviceName() {
        return this.serviceName;
    }

    private LoginManager acquire() {
        ++this.refCount;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            if (this.refCount == 0) {
                throw new IllegalStateException("release called on LoginManager with refCount == 0");
            }
            if (this.refCount == 1) {
                CACHED_INSTANCES.remove((Object)this.loginType);
                this.login.shutdown();
            }
            --this.refCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            for (LoginType loginType : new ArrayList<LoginType>(CACHED_INSTANCES.keySet())) {
                LoginManager loginManager = CACHED_INSTANCES.remove((Object)loginType);
                loginManager.login.shutdown();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

