/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.serialization;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.graylog.shaded.org.apache.kafka09.common.errors.SerializationException;
import org.graylog.shaded.org.apache.kafka09.common.serialization.Serializer;

public class StringSerializer
implements Serializer<String> {
    private String encoding = "UTF8";

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String propertyName = isKey ? "key.serializer.encoding" : "value.serializer.encoding";
        Object encodingValue = configs.get(propertyName);
        if (encodingValue == null) {
            encodingValue = configs.get("serializer.encoding");
        }
        if (encodingValue != null && encodingValue instanceof String) {
            this.encoding = (String)encodingValue;
        }
    }

    @Override
    public byte[] serialize(String topic, String data) {
        try {
            if (data == null) {
                return null;
            }
            return data.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when serializing string to byte[] due to unsupported encoding " + this.encoding);
        }
    }

    @Override
    public void close() {
    }
}

