/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.zookeeper.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jute.Record;
import org.graylog.shaded.org.apache.kafka09.zookeeper.WatchedEvent;
import org.graylog.shaded.org.apache.kafka09.zookeeper.Watcher;
import org.graylog.shaded.org.apache.kafka09.zookeeper.data.Id;
import org.graylog.shaded.org.apache.kafka09.zookeeper.proto.ReplyHeader;
import org.graylog.shaded.org.apache.kafka09.zookeeper.proto.RequestHeader;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ServerStats;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.Stats;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ZooKeeperSaslServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerCnxn
implements Stats,
Watcher {
    public static final Object me = new Object();
    protected ArrayList<Id> authInfo = new ArrayList();
    boolean isOldClient = true;
    protected ZooKeeperSaslServer zooKeeperSaslServer = null;
    protected static final int confCmd = ByteBuffer.wrap("conf".getBytes()).getInt();
    protected static final int consCmd = ByteBuffer.wrap("cons".getBytes()).getInt();
    protected static final int crstCmd = ByteBuffer.wrap("crst".getBytes()).getInt();
    protected static final int dumpCmd = ByteBuffer.wrap("dump".getBytes()).getInt();
    protected static final int enviCmd = ByteBuffer.wrap("envi".getBytes()).getInt();
    protected static final int getTraceMaskCmd = ByteBuffer.wrap("gtmk".getBytes()).getInt();
    protected static final int ruokCmd = ByteBuffer.wrap("ruok".getBytes()).getInt();
    protected static final int setTraceMaskCmd = ByteBuffer.wrap("stmk".getBytes()).getInt();
    protected static final int srvrCmd = ByteBuffer.wrap("srvr".getBytes()).getInt();
    protected static final int srstCmd = ByteBuffer.wrap("srst".getBytes()).getInt();
    protected static final int statCmd = ByteBuffer.wrap("stat".getBytes()).getInt();
    protected static final int wchcCmd = ByteBuffer.wrap("wchc".getBytes()).getInt();
    protected static final int wchpCmd = ByteBuffer.wrap("wchp".getBytes()).getInt();
    protected static final int wchsCmd = ByteBuffer.wrap("wchs".getBytes()).getInt();
    protected static final int mntrCmd = ByteBuffer.wrap("mntr".getBytes()).getInt();
    protected static final int isroCmd = ByteBuffer.wrap("isro".getBytes()).getInt();
    protected static final HashMap<Integer, String> cmd2String = new HashMap();
    protected final Date established = new Date();
    protected final AtomicLong packetsReceived = new AtomicLong();
    protected final AtomicLong packetsSent = new AtomicLong();
    protected long minLatency;
    protected long maxLatency;
    protected String lastOp;
    protected long lastCxid;
    protected long lastZxid;
    protected long lastResponseTime;
    protected long lastLatency;
    protected long count;
    protected long totalLatency;

    abstract int getSessionTimeout();

    abstract void close();

    public abstract void sendResponse(ReplyHeader var1, Record var2, String var3) throws IOException;

    abstract void sendCloseSession();

    @Override
    public abstract void process(WatchedEvent var1);

    abstract long getSessionId();

    abstract void setSessionId(long var1);

    public List<Id> getAuthInfo() {
        return Collections.unmodifiableList(this.authInfo);
    }

    public void addAuthInfo(Id id) {
        if (!this.authInfo.contains(id)) {
            this.authInfo.add(id);
        }
    }

    public boolean removeAuthInfo(Id id) {
        return this.authInfo.remove(id);
    }

    abstract void sendBuffer(ByteBuffer var1);

    abstract void enableRecv();

    abstract void disableRecv();

    abstract void setSessionTimeout(int var1);

    protected void packetReceived() {
        this.incrPacketsReceived();
        ServerStats serverStats = this.serverStats();
        if (serverStats != null) {
            this.serverStats().incrementPacketsReceived();
        }
    }

    protected void packetSent() {
        this.incrPacketsSent();
        ServerStats serverStats = this.serverStats();
        if (serverStats != null) {
            this.serverStats().incrementPacketsSent();
        }
    }

    protected abstract ServerStats serverStats();

    @Override
    public synchronized void resetStats() {
        this.packetsReceived.set(0L);
        this.packetsSent.set(0L);
        this.minLatency = Long.MAX_VALUE;
        this.maxLatency = 0L;
        this.lastOp = "NA";
        this.lastCxid = -1L;
        this.lastZxid = -1L;
        this.lastResponseTime = 0L;
        this.lastLatency = 0L;
        this.count = 0L;
        this.totalLatency = 0L;
    }

    protected long incrPacketsReceived() {
        return this.packetsReceived.incrementAndGet();
    }

    protected void incrOutstandingRequests(RequestHeader h) {
    }

    protected long incrPacketsSent() {
        return this.packetsSent.incrementAndGet();
    }

    protected synchronized void updateStatsForResponse(long cxid, long zxid, String op, long start, long end) {
        long elapsed;
        if (cxid >= 0L) {
            this.lastCxid = cxid;
        }
        this.lastZxid = zxid;
        this.lastOp = op;
        this.lastResponseTime = end;
        this.lastLatency = elapsed = end - start;
        if (elapsed < this.minLatency) {
            this.minLatency = elapsed;
        }
        if (elapsed > this.maxLatency) {
            this.maxLatency = elapsed;
        }
        ++this.count;
        this.totalLatency += elapsed;
    }

    @Override
    public Date getEstablished() {
        return (Date)this.established.clone();
    }

    @Override
    public abstract long getOutstandingRequests();

    @Override
    public long getPacketsReceived() {
        return this.packetsReceived.longValue();
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent.longValue();
    }

    @Override
    public synchronized long getMinLatency() {
        return this.minLatency == Long.MAX_VALUE ? 0L : this.minLatency;
    }

    @Override
    public synchronized long getAvgLatency() {
        return this.count == 0L ? 0L : this.totalLatency / this.count;
    }

    @Override
    public synchronized long getMaxLatency() {
        return this.maxLatency;
    }

    @Override
    public synchronized String getLastOperation() {
        return this.lastOp;
    }

    @Override
    public synchronized long getLastCxid() {
        return this.lastCxid;
    }

    @Override
    public synchronized long getLastZxid() {
        return this.lastZxid;
    }

    @Override
    public synchronized long getLastResponseTime() {
        return this.lastResponseTime;
    }

    @Override
    public synchronized long getLastLatency() {
        return this.lastLatency;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pwriter = new PrintWriter(sw);
        this.dumpConnectionInfo(pwriter, false);
        pwriter.flush();
        pwriter.close();
        return sw.toString();
    }

    public abstract InetSocketAddress getRemoteSocketAddress();

    public abstract int getInterestOps();

    protected synchronized void dumpConnectionInfo(PrintWriter pwriter, boolean brief) {
        long sessionId;
        pwriter.print(" ");
        pwriter.print(this.getRemoteSocketAddress());
        pwriter.print("[");
        int interestOps = this.getInterestOps();
        pwriter.print(interestOps == 0 ? "0" : Integer.toHexString(interestOps));
        pwriter.print("](queued=");
        pwriter.print(this.getOutstandingRequests());
        pwriter.print(",recved=");
        pwriter.print(this.getPacketsReceived());
        pwriter.print(",sent=");
        pwriter.print(this.getPacketsSent());
        if (!brief && (sessionId = this.getSessionId()) != 0L) {
            pwriter.print(",sid=0x");
            pwriter.print(Long.toHexString(sessionId));
            pwriter.print(",lop=");
            pwriter.print(this.getLastOperation());
            pwriter.print(",est=");
            pwriter.print(this.getEstablished().getTime());
            pwriter.print(",to=");
            pwriter.print(this.getSessionTimeout());
            long lastCxid = this.getLastCxid();
            if (lastCxid >= 0L) {
                pwriter.print(",lcxid=0x");
                pwriter.print(Long.toHexString(lastCxid));
            }
            pwriter.print(",lzxid=0x");
            pwriter.print(Long.toHexString(this.getLastZxid()));
            pwriter.print(",lresp=");
            pwriter.print(this.getLastResponseTime());
            pwriter.print(",llat=");
            pwriter.print(this.getLastLatency());
            pwriter.print(",minlat=");
            pwriter.print(this.getMinLatency());
            pwriter.print(",avglat=");
            pwriter.print(this.getAvgLatency());
            pwriter.print(",maxlat=");
            pwriter.print(this.getMaxLatency());
        }
        pwriter.print(")");
    }

    static {
        cmd2String.put(confCmd, "conf");
        cmd2String.put(consCmd, "cons");
        cmd2String.put(crstCmd, "crst");
        cmd2String.put(dumpCmd, "dump");
        cmd2String.put(enviCmd, "envi");
        cmd2String.put(getTraceMaskCmd, "gtmk");
        cmd2String.put(ruokCmd, "ruok");
        cmd2String.put(setTraceMaskCmd, "stmk");
        cmd2String.put(srstCmd, "srst");
        cmd2String.put(srvrCmd, "srvr");
        cmd2String.put(statCmd, "stat");
        cmd2String.put(wchcCmd, "wchc");
        cmd2String.put(wchpCmd, "wchp");
        cmd2String.put(wchsCmd, "wchs");
        cmd2String.put(mntrCmd, "mntr");
        cmd2String.put(isroCmd, "isro");
    }

    protected static class EndOfStreamException
    extends IOException {
        private static final long serialVersionUID = -8255690282104294178L;

        public EndOfStreamException(String msg) {
            super(msg);
        }

        public String toString() {
            return "EndOfStreamException: " + this.getMessage();
        }
    }

    protected static class CloseRequestException
    extends IOException {
        private static final long serialVersionUID = -7854505709816442681L;

        public CloseRequestException(String msg) {
            super(msg);
        }
    }
}

