/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.zookeeper.server;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.apache.jute.BinaryInputArchive;
import org.graylog.shaded.org.apache.kafka09.zookeeper.data.StatPersisted;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.DataNode;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.DataTree;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.persistence.FileSnap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotFormatter {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("USAGE: SnapshotFormatter snapshot_file");
            System.exit(2);
        }
        new SnapshotFormatter().run(args[0]);
    }

    public void run(String snapshotFileName) throws IOException {
        CheckedInputStream is = new CheckedInputStream(new BufferedInputStream(new FileInputStream(snapshotFileName)), new Adler32());
        BinaryInputArchive ia = BinaryInputArchive.getArchive(is);
        FileSnap fileSnap = new FileSnap(null);
        DataTree dataTree = new DataTree();
        HashMap<Long, Integer> sessions = new HashMap<Long, Integer>();
        fileSnap.deserialize(dataTree, sessions, ia);
        this.printDetails(dataTree, sessions);
    }

    private void printDetails(DataTree dataTree, Map<Long, Integer> sessions) {
        this.printZnodeDetails(dataTree);
        this.printSessionDetails(dataTree, sessions);
    }

    private void printZnodeDetails(DataTree dataTree) {
        System.out.println(String.format("ZNode Details (count=%d):", dataTree.getNodeCount()));
        this.printZnode(dataTree, "/");
        System.out.println("----");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printZnode(DataTree dataTree, String name) {
        Set<String> children;
        DataNode n;
        System.out.println("----");
        DataNode dataNode = n = dataTree.getNode(name);
        synchronized (dataNode) {
            System.out.println(name);
            this.printStat(n.stat);
            if (n.data != null) {
                System.out.println("  dataLength = " + n.data.length);
            } else {
                System.out.println("  no data");
            }
            children = n.getChildren();
        }
        if (children != null) {
            for (String child : children) {
                this.printZnode(dataTree, name + (name.equals("/") ? "" : "/") + child);
            }
        }
    }

    private void printSessionDetails(DataTree dataTree, Map<Long, Integer> sessions) {
        System.out.println("Session Details (sid, timeout, ephemeralCount):");
        for (Map.Entry<Long, Integer> e : sessions.entrySet()) {
            long sid = e.getKey();
            System.out.println(String.format("%#016x, %d, %d", sid, e.getValue(), dataTree.getEphemerals(sid).size()));
        }
    }

    private void printStat(StatPersisted stat) {
        this.printHex("cZxid", stat.getCzxid());
        System.out.println("  ctime = " + new Date(stat.getCtime()).toString());
        this.printHex("mZxid", stat.getMzxid());
        System.out.println("  mtime = " + new Date(stat.getMtime()).toString());
        this.printHex("pZxid", stat.getPzxid());
        System.out.println("  cversion = " + stat.getCversion());
        System.out.println("  dataVersion = " + stat.getVersion());
        System.out.println("  aclVersion = " + stat.getAversion());
        this.printHex("ephemeralOwner", stat.getEphemeralOwner());
    }

    private void printHex(String prefix, long value2) {
        System.out.println(String.format("  %s = %#016x", prefix, value2));
    }
}

