/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.graylog.shaded.org.apache.kafka09.zookeeper.KeeperException;
import org.graylog.shaded.org.apache.kafka09.zookeeper.Watcher;
import org.graylog.shaded.org.apache.kafka09.zookeeper.data.ACL;
import org.graylog.shaded.org.apache.kafka09.zookeeper.data.Stat;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.DataNode;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.DataTree;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.Request;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ServerCnxn;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.persistence.FileTxnSnapLog;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.Leader;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.QuorumPacket;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.util.SerializeUtils;
import org.graylog.shaded.org.apache.kafka09.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZKDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(ZKDatabase.class);
    protected DataTree dataTree;
    protected ConcurrentHashMap<Long, Integer> sessionsWithTimeouts;
    protected FileTxnSnapLog snapLog;
    protected long minCommittedLog;
    protected long maxCommittedLog;
    public static final int commitLogCount = 500;
    protected static int commitLogBuffer = 700;
    protected LinkedList<Leader.Proposal> committedLog = new LinkedList();
    protected ReentrantReadWriteLock logLock = new ReentrantReadWriteLock();
    private volatile boolean initialized = false;

    public ZKDatabase(FileTxnSnapLog snapLog) {
        this.dataTree = new DataTree();
        this.sessionsWithTimeouts = new ConcurrentHashMap();
        this.snapLog = snapLog;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.minCommittedLog = 0L;
        this.maxCommittedLog = 0L;
        this.dataTree = new DataTree();
        this.sessionsWithTimeouts.clear();
        ReentrantReadWriteLock.WriteLock lock2 = this.logLock.writeLock();
        try {
            lock2.lock();
            this.committedLog.clear();
            Object var3_2 = null;
            lock2.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock2.unlock();
            throw throwable;
        }
        this.initialized = false;
    }

    public DataTree getDataTree() {
        return this.dataTree;
    }

    public long getmaxCommittedLog() {
        return this.maxCommittedLog;
    }

    public long getminCommittedLog() {
        return this.minCommittedLog;
    }

    public ReentrantReadWriteLock getLogLock() {
        return this.logLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LinkedList<Leader.Proposal> getCommittedLog() {
        ReentrantReadWriteLock.ReadLock rl = this.logLock.readLock();
        if (this.logLock.getReadHoldCount() <= 0) {
            try {
                rl.lock();
                LinkedList<Leader.Proposal> linkedList = new LinkedList<Leader.Proposal>(this.committedLog);
                Object var4_3 = null;
                rl.unlock();
                return linkedList;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                rl.unlock();
                throw throwable;
            }
        }
        return this.committedLog;
    }

    public long getDataTreeLastProcessedZxid() {
        return this.dataTree.lastProcessedZxid;
    }

    public void setDataTreeInit(boolean b) {
        this.dataTree.initialized = b;
    }

    public Collection<Long> getSessions() {
        return this.dataTree.getSessions();
    }

    public ConcurrentHashMap<Long, Integer> getSessionWithTimeOuts() {
        return this.sessionsWithTimeouts;
    }

    public long loadDataBase() throws IOException {
        FileTxnSnapLog.PlayBackListener listener = new FileTxnSnapLog.PlayBackListener(){

            public void onTxnLoaded(TxnHeader hdr, Record txn) {
                Request r = new Request(null, 0L, hdr.getCxid(), hdr.getType(), null, null);
                r.txn = txn;
                r.hdr = hdr;
                r.zxid = hdr.getZxid();
                ZKDatabase.this.addCommittedProposal(r);
            }
        };
        long zxid = this.snapLog.restore(this.dataTree, this.sessionsWithTimeouts, listener);
        this.initialized = true;
        return zxid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommittedProposal(Request request) {
        ReentrantReadWriteLock.WriteLock wl = this.logLock.writeLock();
        try {
            wl.lock();
            if (this.committedLog.size() > 500) {
                this.committedLog.removeFirst();
                this.minCommittedLog = this.committedLog.getFirst().packet.getZxid();
            }
            if (this.committedLog.size() == 0) {
                this.minCommittedLog = request.zxid;
                this.maxCommittedLog = request.zxid;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
            try {
                request.hdr.serialize(boa, "hdr");
                if (request.txn != null) {
                    request.txn.serialize(boa, "txn");
                }
                baos.close();
            }
            catch (IOException e) {
                LOG.error("This really should be impossible", (Throwable)e);
            }
            QuorumPacket pp = new QuorumPacket(2, request.zxid, baos.toByteArray(), null);
            Leader.Proposal p = new Leader.Proposal();
            p.packet = pp;
            p.request = request;
            this.committedLog.add(p);
            this.maxCommittedLog = p.packet.getZxid();
            Object var8_8 = null;
            wl.unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wl.unlock();
            throw throwable;
        }
    }

    public void removeCnxn(ServerCnxn cnxn) {
        this.dataTree.removeCnxn(cnxn);
    }

    public void killSession(long sessionId, long zxid) {
        this.dataTree.killSession(sessionId, zxid);
    }

    public void dumpEphemerals(PrintWriter pwriter) {
        this.dataTree.dumpEphemerals(pwriter);
    }

    public int getNodeCount() {
        return this.dataTree.getNodeCount();
    }

    public HashSet<String> getEphemerals(long sessionId) {
        return this.dataTree.getEphemerals(sessionId);
    }

    public void setlastProcessedZxid(long zxid) {
        this.dataTree.lastProcessedZxid = zxid;
    }

    public DataTree.ProcessTxnResult processTxn(TxnHeader hdr, Record txn) {
        return this.dataTree.processTxn(hdr, txn);
    }

    public Stat statNode(String path, ServerCnxn serverCnxn) throws KeeperException.NoNodeException {
        return this.dataTree.statNode(path, serverCnxn);
    }

    public DataNode getNode(String path) {
        return this.dataTree.getNode(path);
    }

    public List<ACL> convertLong(Long aclL) {
        return this.dataTree.convertLong(aclL);
    }

    public byte[] getData(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        return this.dataTree.getData(path, stat, watcher);
    }

    public void setWatches(long relativeZxid, List<String> dataWatches, List<String> existWatches, List<String> childWatches, Watcher watcher) {
        this.dataTree.setWatches(relativeZxid, dataWatches, existWatches, childWatches, watcher);
    }

    public List<ACL> getACL(String path, Stat stat) throws KeeperException.NoNodeException {
        return this.dataTree.getACL(path, stat);
    }

    public List<String> getChildren(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        return this.dataTree.getChildren(path, stat, watcher);
    }

    public boolean isSpecialPath(String path) {
        return this.dataTree.isSpecialPath(path);
    }

    public int getAclSize() {
        return this.dataTree.longKeyMap.size();
    }

    public boolean truncateLog(long zxid) throws IOException {
        this.clear();
        boolean truncated = this.snapLog.truncateLog(zxid);
        if (!truncated) {
            return false;
        }
        this.loadDataBase();
        return true;
    }

    public void deserializeSnapshot(InputArchive ia) throws IOException {
        this.clear();
        SerializeUtils.deserializeSnapshot(this.getDataTree(), ia, this.getSessionWithTimeOuts());
        this.initialized = true;
    }

    public void serializeSnapshot(OutputArchive oa) throws IOException, InterruptedException {
        SerializeUtils.serializeSnapshot(this.getDataTree(), oa, this.getSessionWithTimeOuts());
    }

    public boolean append(Request si) throws IOException {
        return this.snapLog.append(si);
    }

    public void rollLog() throws IOException {
        this.snapLog.rollLog();
    }

    public void commit() throws IOException {
        this.snapLog.commit();
    }

    public void close() throws IOException {
        this.snapLog.close();
    }
}

