/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.admin;

import java.util.Map;
import java.util.Properties;
import org.graylog.shaded.kafka09.admin.AdminUtils$;
import org.graylog.shaded.kafka09.admin.ConfigCommand;
import org.graylog.shaded.kafka09.admin.TopicCommand$;
import org.graylog.shaded.kafka09.log.Defaults$;
import org.graylog.shaded.kafka09.log.LogConfig$;
import org.graylog.shaded.kafka09.scala.Function0;
import org.graylog.shaded.kafka09.scala.Function1;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.JavaConversions$;
import org.graylog.shaded.kafka09.scala.collection.Seq;
import org.graylog.shaded.kafka09.scala.collection.Seq$;
import org.graylog.shaded.kafka09.scala.collection.TraversableOnce;
import org.graylog.shaded.kafka09.scala.collection.immutable.StringOps;
import org.graylog.shaded.kafka09.scala.collection.mutable.Buffer;
import org.graylog.shaded.kafka09.scala.collection.mutable.Buffer$;
import org.graylog.shaded.kafka09.scala.collection.mutable.Iterable$;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.server.ConfigType$;
import org.graylog.shaded.kafka09.utils.CommandLineUtils$;
import org.graylog.shaded.kafka09.utils.ZkUtils;
import org.graylog.shaded.kafka09.utils.ZkUtils$;
import org.graylog.shaded.org.apache.kafka09.common.security.JaasUtils;
import org.graylog.shaded.org.apache.kafka09.common.utils.Utils;

public final class ConfigCommand$ {
    public static final ConfigCommand$ MODULE$;

    static {
        new ConfigCommand$();
    }

    public void main(String[] args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Add/Remove entity (topics/clients) configs");
        }
        opts.checkArgs();
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(opts.options().valueOf(opts.zkConnectOpt()), 30000, 30000, JaasUtils.isZkSecurityEnabled());
        try {
            try {
                if (opts.options().has(opts.alterOpt())) {
                    this.alterConfig(zkUtils, opts);
                } else if (opts.options().has(opts.describeOpt())) {
                    this.describeConfig(zkUtils, opts);
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println(new StringBuilder().append((Object)"Error while executing topic command ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println(Utils.stackTrace(throwable));
            }
        }
        finally {
            zkUtils.close();
        }
    }

    private void alterConfig(ZkUtils zkUtils, ConfigCommand.ConfigCommandOptions opts) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        String entityType = opts.options().valueOf(opts.entityType());
        String entityName = opts.options().valueOf(opts.entityName());
        this.warnOnMaxMessagesChange(configsToBeAdded);
        Properties configs = AdminUtils$.MODULE$.fetchEntityConfig(zkUtils, entityType, entityName);
        configs.putAll((Map<?, ?>)configsToBeAdded);
        configsToBeDeleted.foreach(new Serializable(configs){
            public static final long serialVersionUID = 0L;
            private final Properties configs$1;

            public final Object apply(String config) {
                return this.configs$1.remove(config);
            }
            {
                this.configs$1 = configs$1;
            }
        });
        if (entityType.equals(ConfigType$.MODULE$.Topic())) {
            AdminUtils$.MODULE$.changeTopicConfig(zkUtils, entityName, configs);
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Updated config for topic: \"%s\".")).format(Predef$.MODULE$.genericWrapArray(new Object[]{entityName})));
        } else {
            AdminUtils$.MODULE$.changeClientIdConfig(zkUtils, entityName, configs);
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Updated config for clientId: \"%s\".")).format(Predef$.MODULE$.genericWrapArray(new Object[]{entityName})));
        }
    }

    public void warnOnMaxMessagesChange(Properties configs) {
        int n;
        Object object = configs.get(LogConfig$.MODULE$.MaxMessageBytesProp());
        if (object instanceof String) {
            String string2 = (String)object;
            n = new StringOps(Predef$.MODULE$.augmentString(string2)).toInt();
        } else {
            n = -1;
        }
        int maxMessageBytes = n;
        if (maxMessageBytes > Defaults$.MODULE$.MaxMessageSize()) {
            TopicCommand$.MODULE$.error((Function0<String>)((Object)new Serializable(maxMessageBytes){
                public static final long serialVersionUID = 0L;
                private final int maxMessageBytes$1;

                public final String apply() {
                    return TopicCommand$.MODULE$.longMessageSizeWarning(this.maxMessageBytes$1);
                }
                {
                    this.maxMessageBytes$1 = maxMessageBytes$1;
                }
            }));
            TopicCommand$.MODULE$.askToProceed();
        }
    }

    private void describeConfig(ZkUtils zkUtils, ConfigCommand.ConfigCommandOptions opts) {
        String entityType = opts.options().valueOf(opts.entityType());
        Seq entityNames = opts.options().has(opts.entityName()) ? (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{opts.options().valueOf(opts.entityName())})) : zkUtils.getAllEntitiesWithConfig(entityType);
        entityNames.foreach(new Serializable(zkUtils, entityType){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final String entityType$1;

            public final void apply(String entityName) {
                Properties configs = AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$1, this.entityType$1, entityName);
                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Configs for %s:%s are %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.entityType$1, entityName, ((TraversableOnce)JavaConversions$.MODULE$.propertiesAsScalaMap(configs).map((Function1<String, String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> kv) {
                        return new StringBuilder().append((Object)kv._1()).append((Object)"=").append((Object)kv._2()).toString();
                    }
                }), Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.entityType$1 = entityType$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var3_3;
        Buffer<String[]> configsToBeAdded = JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.addConfig())).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split("\\s*=\\s*");
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1<String[], Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] config) {
                return config.length == 2;
            }
        })), (Function0<Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid entity config: all configs to be added must be in the format \"key=val\".";
            }
        }));
        Properties props = new Properties();
        configsToBeAdded.foreach(new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String[] pair) {
                return this.props$1.setProperty(pair[0].trim(), pair[1].trim());
            }
            {
                this.props$1 = props$1;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer<String> configsToBeDeleted = JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.deleteConfig())).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$2) {
                    return x$2.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach(new Serializable(propsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Properties propsToBeDeleted$1;

                public final Object apply(String x$3) {
                    return this.propsToBeDeleted$1.setProperty(x$3, "");
                }
                {
                    this.propsToBeDeleted$1 = propsToBeDeleted$1;
                }
            });
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    private ConfigCommand$() {
        MODULE$ = this;
    }
}

