/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.joptsimple.util;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.graylog.shaded.kafka09.joptsimple.ValueConversionException;
import org.graylog.shaded.kafka09.joptsimple.ValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateConverter
implements ValueConverter<Date> {
    private final DateFormat formatter;

    public DateConverter(DateFormat formatter) {
        if (formatter == null) {
            throw new NullPointerException("illegal null formatter");
        }
        this.formatter = formatter;
    }

    public static DateConverter datePattern(String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        formatter.setLenient(false);
        return new DateConverter(formatter);
    }

    @Override
    public Date convert(String value2) {
        ParsePosition position = new ParsePosition(0);
        Date date = this.formatter.parse(value2, position);
        if (position.getIndex() != value2.length()) {
            throw new ValueConversionException(this.message(value2));
        }
        return date;
    }

    @Override
    public Class<Date> valueType() {
        return Date.class;
    }

    @Override
    public String valuePattern() {
        return this.formatter instanceof SimpleDateFormat ? ((SimpleDateFormat)this.formatter).toLocalizedPattern() : "";
    }

    private String message(String value2) {
        String message = "Value [" + value2 + "] does not match date/time pattern";
        if (this.formatter instanceof SimpleDateFormat) {
            message = message + " [" + ((SimpleDateFormat)this.formatter).toLocalizedPattern() + ']';
        }
        return message;
    }
}

