/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.I0Itec.zkclient;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;

public class NetworkUtil {
    public static final String OVERWRITE_HOSTNAME_SYSTEM_PROPERTY = "zkclient.hostname.overwritten";

    public static String[] getLocalHostNames() {
        HashSet<String> hostNames = new HashSet<String>();
        hostNames.add("localhost");
        try {
            Enumeration<NetworkInterface> networkInterfaces;
            Enumeration<NetworkInterface> ifaces = networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                InetAddress ia = null;
                Enumeration<InetAddress> ips = iface.getInetAddresses();
                while (ips.hasMoreElements()) {
                    ia = ips.nextElement();
                    hostNames.add(ia.getCanonicalHostName());
                    hostNames.add(NetworkUtil.ipToString(ia.getAddress()));
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("unable to retrieve host names of localhost");
        }
        return hostNames.toArray(new String[hostNames.size()]);
    }

    private static String ipToString(byte[] bytes) {
        StringBuffer addrStr = new StringBuffer();
        for (int cnt = 0; cnt < bytes.length; ++cnt) {
            int uByte = bytes[cnt] < 0 ? bytes[cnt] + 256 : bytes[cnt];
            addrStr.append(uByte);
            if (cnt >= 3) continue;
            addrStr.append('.');
        }
        return addrStr.toString();
    }

    public static int hostNamesInList(String serverList, String[] hostNames) {
        String[] serverNames = serverList.split(",");
        for (int i = 0; i < hostNames.length; ++i) {
            String hostname = hostNames[i];
            for (int j = 0; j < serverNames.length; ++j) {
                String serverNameAndPort = serverNames[j];
                String serverName = serverNameAndPort.split(":")[0];
                if (!serverName.equalsIgnoreCase(hostname)) continue;
                return j;
            }
        }
        return -1;
    }

    public static boolean hostNameInArray(String[] hostNames, String hostName) {
        for (String name : hostNames) {
            if (!name.equalsIgnoreCase(hostName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortFree(int port) {
        try {
            Socket socket = new Socket("localhost", port);
            socket.close();
            return false;
        }
        catch (ConnectException e) {
            return true;
        }
        catch (SocketException e) {
            if (e.getMessage().equals("Connection reset by peer")) {
                return true;
            }
            throw new RuntimeException(e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLocalhostName() {
        String property = System.getProperty(OVERWRITE_HOSTNAME_SYSTEM_PROPERTY);
        if (property != null && property.trim().length() > 0) {
            return property;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("unable to retrieve localhost name");
        }
    }
}

