/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.org.I0Itec.zkclient.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class TcclAwareObjectIputStream
extends ObjectInputStream {
    public TcclAwareObjectIputStream(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        try {
            return this.getClass().getClassLoader().loadClass(classDesc.getName());
        }
        catch (ClassNotFoundException ex) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                return tccl.loadClass(classDesc.getName());
            }
            throw ex;
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader cl = this.getClass().getClassLoader();
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                cinterfaces[i] = cl.loadClass(interfaces[i]);
                continue;
            }
            catch (ClassNotFoundException ex) {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                if (tccl != null) {
                    return tccl.loadClass(interfaces[i]);
                }
                throw ex;
            }
        }
        try {
            return Proxy.getProxyClass(cinterfaces[0].getClassLoader(), cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

